/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.awt.Color;
import java.util.HashMap;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class ColorConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return clazz.getName().equals("java.awt.Color");
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Color color = (Color)object;
        this.write("red", color.getRed(), hierarchicalStreamWriter);
        this.write("green", color.getGreen(), hierarchicalStreamWriter);
        this.write("blue", color.getBlue(), hierarchicalStreamWriter);
        this.write("alpha", color.getAlpha(), hierarchicalStreamWriter);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            hashMap.put(hierarchicalStreamReader.getNodeName(), Integer.valueOf(hierarchicalStreamReader.getValue()));
            hierarchicalStreamReader.moveUp();
        }
        return new Color((Integer)hashMap.get("red"), (Integer)hashMap.get("green"), (Integer)hashMap.get("blue"), (Integer)hashMap.get("alpha"));
    }

    private void write(String string, int n2, HierarchicalStreamWriter hierarchicalStreamWriter) {
        ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, string, Integer.TYPE);
        hierarchicalStreamWriter.setValue(String.valueOf(n2));
        hierarchicalStreamWriter.endNode();
    }
}

