/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.core.util.Fields;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.DynamicProxyMapper;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class DynamicProxyConverter
implements Converter {
    private ClassLoaderReference classLoaderReference;
    private Mapper mapper;
    private static final Field HANDLER = Fields.locate(Proxy.class, InvocationHandler.class, false);
    private static final InvocationHandler DUMMY = new InvocationHandler(){

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            return null;
        }
    };

    public DynamicProxyConverter(Mapper mapper) {
        this(mapper, DynamicProxyConverter.class.getClassLoader());
    }

    public DynamicProxyConverter(Mapper mapper, ClassLoaderReference classLoaderReference) {
        this.classLoaderReference = classLoaderReference;
        this.mapper = mapper;
    }

    public DynamicProxyConverter(Mapper mapper, ClassLoader classLoader) {
        this(mapper, new ClassLoaderReference(classLoader));
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(DynamicProxyMapper.DynamicProxy.class) || Proxy.isProxyClass(clazz);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
        this.addInterfacesToXml(object, hierarchicalStreamWriter);
        hierarchicalStreamWriter.startNode("handler");
        String string = this.mapper.aliasForSystemAttribute("class");
        if (string != null) {
            hierarchicalStreamWriter.addAttribute(string, this.mapper.serializedClass(invocationHandler.getClass()));
        }
        marshallingContext.convertAnother(invocationHandler);
        hierarchicalStreamWriter.endNode();
    }

    private void addInterfacesToXml(Object object, HierarchicalStreamWriter hierarchicalStreamWriter) {
        Class<?>[] classArray = object.getClass().getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class<?> clazz = classArray[i2];
            hierarchicalStreamWriter.startNode("interface");
            hierarchicalStreamWriter.setValue(this.mapper.serializedClass(clazz));
            hierarchicalStreamWriter.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Object object;
        Class[] classArray;
        ArrayList<Class> arrayList = new ArrayList<Class>();
        InvocationHandler invocationHandler = null;
        Class clazz = null;
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            classArray = hierarchicalStreamReader.getNodeName();
            if (classArray.equals("interface")) {
                arrayList.add(this.mapper.realClass(hierarchicalStreamReader.getValue()));
            } else if (classArray.equals("handler") && (object = this.mapper.aliasForSystemAttribute("class")) != null) {
                clazz = this.mapper.realClass(hierarchicalStreamReader.getAttribute((String)object));
                break;
            }
            hierarchicalStreamReader.moveUp();
        }
        if (clazz == null) {
            throw new ConversionException("No InvocationHandler specified for dynamic proxy");
        }
        classArray = new Class[arrayList.size()];
        arrayList.toArray(classArray);
        object = null;
        if (HANDLER != null) {
            object = Proxy.newProxyInstance(this.classLoaderReference.getReference(), classArray, DUMMY);
        }
        invocationHandler = (InvocationHandler)unmarshallingContext.convertAnother(object, clazz);
        hierarchicalStreamReader.moveUp();
        if (HANDLER != null) {
            Fields.write(HANDLER, object, invocationHandler);
        } else {
            object = Proxy.newProxyInstance(this.classLoaderReference.getReference(), classArray, invocationHandler);
        }
        return object;
    }
}

