/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.util.ArrayList;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.basic.ByteConverter;
import zz.com.thoughtworks.xstream.core.util.Base64Encoder;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class EncodedByteArrayConverter
implements Converter,
SingleValueConverter {
    private static final Base64Encoder base64 = new Base64Encoder();
    private static final ByteConverter byteConverter = new ByteConverter();

    public boolean canConvert(Class clazz) {
        return clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        hierarchicalStreamWriter.setValue(this.toString(object));
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String string = hierarchicalStreamReader.getValue();
        if (!hierarchicalStreamReader.hasMoreChildren()) {
            return this.fromString(string);
        }
        return this.unmarshalIndividualByteElements(hierarchicalStreamReader, unmarshallingContext);
    }

    private Object unmarshalIndividualByteElements(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl2 = true;
        while (bl2 || hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            arrayList.add(byteConverter.fromString(hierarchicalStreamReader.getValue()));
            hierarchicalStreamReader.moveUp();
            bl2 = false;
        }
        byte[] byArray = new byte[arrayList.size()];
        int n2 = 0;
        for (Byte by2 : arrayList) {
            byArray[n2] = by2;
            ++n2;
        }
        return byArray;
    }

    public String toString(Object object) {
        return base64.encode((byte[])object);
    }

    public Object fromString(String string) {
        return base64.decode(string);
    }
}

