/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.plaf.FontUIResource;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.extended.TextAttributeConverter;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class FontConverter
implements Converter {
    private final SingleValueConverter textAttributeConverter;
    private final Mapper mapper;

    public FontConverter() {
        this(null);
    }

    public FontConverter(Mapper mapper) {
        this.mapper = mapper;
        this.textAttributeConverter = mapper == null ? null : new TextAttributeConverter();
    }

    public boolean canConvert(Class clazz) {
        return clazz.getName().equals("java.awt.Font") || clazz.getName().equals("javax.swing.plaf.FontUIResource");
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Font font = (Font)object;
        Map<TextAttribute, ?> map = font.getAttributes();
        if (this.mapper != null) {
            String string = this.mapper.aliasForSystemAttribute("class");
            for (Map.Entry<TextAttribute, ?> entry : map.entrySet()) {
                String string2 = this.textAttributeConverter.toString(entry.getKey());
                Object obj = entry.getValue();
                Class clazz = obj != null ? obj.getClass() : Mapper.Null.class;
                ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, string2, clazz);
                hierarchicalStreamWriter.addAttribute(string, this.mapper.serializedClass(clazz));
                if (obj != null) {
                    marshallingContext.convertAnother(obj);
                }
                hierarchicalStreamWriter.endNode();
            }
        } else {
            hierarchicalStreamWriter.startNode("attributes");
            marshallingContext.convertAnother(map);
            hierarchicalStreamWriter.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        HashMap<TextAttribute, Object> hashMap;
        Object object;
        if (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            if (!hierarchicalStreamReader.getNodeName().equals("attributes")) {
                object = this.mapper.aliasForSystemAttribute("class");
                hashMap = new HashMap<TextAttribute, Object>();
                do {
                    if (!hashMap.isEmpty()) {
                        hierarchicalStreamReader.moveDown();
                    }
                    Class clazz = this.mapper.realClass(hierarchicalStreamReader.getAttribute((String)object));
                    TextAttribute textAttribute = (TextAttribute)this.textAttributeConverter.fromString(hierarchicalStreamReader.getNodeName());
                    Object object2 = clazz == Mapper.Null.class ? null : unmarshallingContext.convertAnother(null, clazz);
                    hashMap.put(textAttribute, object2);
                    hierarchicalStreamReader.moveUp();
                } while (hierarchicalStreamReader.hasMoreChildren());
            } else {
                hashMap = (Map)unmarshallingContext.convertAnother(null, Map.class);
                hierarchicalStreamReader.moveUp();
            }
        } else {
            hashMap = Collections.EMPTY_MAP;
        }
        if (!JVM.is16()) {
            object = hashMap.values().iterator();
            while (object.hasNext()) {
                if (object.next() != null) continue;
                object.remove();
            }
        }
        object = Font.getFont(hashMap);
        if (unmarshallingContext.getRequiredType() == FontUIResource.class) {
            return new FontUIResource((Font)object);
        }
        return object;
    }
}

