/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class GregorianCalendarConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return clazz.equals(GregorianCalendar.class);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, "time", Long.TYPE);
        long l2 = gregorianCalendar.getTime().getTime();
        hierarchicalStreamWriter.setValue(String.valueOf(l2));
        hierarchicalStreamWriter.endNode();
        ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, "timezone", String.class);
        hierarchicalStreamWriter.setValue(gregorianCalendar.getTimeZone().getID());
        hierarchicalStreamWriter.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String string;
        hierarchicalStreamReader.moveDown();
        long l2 = Long.parseLong(hierarchicalStreamReader.getValue());
        hierarchicalStreamReader.moveUp();
        if (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            string = hierarchicalStreamReader.getValue();
            hierarchicalStreamReader.moveUp();
        } else {
            string = TimeZone.getDefault().getID();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone(string));
        gregorianCalendar.setTime(new Date(l2));
        return gregorianCalendar;
    }
}

