/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.sql.Timestamp;
import java.util.Date;
import zz.com.thoughtworks.xstream.converters.extended.ISO8601DateConverter;

public class ISO8601SqlTimestampConverter
extends ISO8601DateConverter {
    private static final String PADDING = "000000000";

    public boolean canConvert(Class clazz) {
        return clazz.equals(Timestamp.class) && super.canConvert(Date.class);
    }

    public Object fromString(String string) {
        int n2 = string.lastIndexOf(46);
        int n3 = 0;
        if (n2 > 0) {
            int n4 = n2 + 1;
            while (Character.isDigit(string.charAt(n4))) {
                ++n4;
            }
            n3 = Integer.parseInt(string.substring(n2 + 1, n4));
            string = string.substring(0, n2) + string.substring(n4);
        }
        Date date = (Date)super.fromString(string);
        Timestamp timestamp = new Timestamp(date.getTime());
        timestamp.setNanos(n3);
        return timestamp;
    }

    public String toString(Object object) {
        Timestamp timestamp = (Timestamp)object;
        String string = super.toString(new Date(timestamp.getTime() / 1000L * 1000L));
        String string2 = String.valueOf(timestamp.getNanos());
        int n2 = string.lastIndexOf(46);
        string = string.substring(0, n2 + 1) + PADDING.substring(string2.length()) + string2 + string.substring(n2 + 4);
        return string;
    }
}

