/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.mapper.CannotResolveClassException;
import zz.com.thoughtworks.xstream.mapper.DefaultMapper;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class JavaClassConverter
extends AbstractSingleValueConverter {
    private Mapper mapper;

    public JavaClassConverter(ClassLoaderReference classLoaderReference) {
        this(new DefaultMapper(classLoaderReference));
    }

    public JavaClassConverter(ClassLoader classLoader) {
        this(new ClassLoaderReference(classLoader));
    }

    protected JavaClassConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class clazz) {
        return Class.class.equals((Object)clazz);
    }

    public String toString(Object object) {
        return this.mapper.serializedClass((Class)object);
    }

    public Object fromString(String string) {
        try {
            return this.mapper.realClass(string);
        }
        catch (CannotResolveClassException cannotResolveClassException) {
            throw new ConversionException("Cannot load java class " + string, cannotResolveClassException.getCause());
        }
    }
}

