/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.lang.reflect.Field;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.DefaultMapper;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class JavaFieldConverter
implements Converter {
    private final SingleValueConverter javaClassConverter;
    private final Mapper mapper;

    public JavaFieldConverter(ClassLoaderReference classLoaderReference) {
        this(new JavaClassConverter(classLoaderReference), new DefaultMapper(classLoaderReference));
    }

    public JavaFieldConverter(ClassLoader classLoader) {
        this(new ClassLoaderReference(classLoader));
    }

    protected JavaFieldConverter(SingleValueConverter singleValueConverter, Mapper mapper) {
        this.javaClassConverter = singleValueConverter;
        this.mapper = mapper;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Field.class);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Field field = (Field)object;
        Class<?> clazz = field.getDeclaringClass();
        hierarchicalStreamWriter.startNode("name");
        hierarchicalStreamWriter.setValue(this.mapper.serializedMember(clazz, field.getName()));
        hierarchicalStreamWriter.endNode();
        hierarchicalStreamWriter.startNode("clazz");
        hierarchicalStreamWriter.setValue(this.javaClassConverter.toString(clazz));
        hierarchicalStreamWriter.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String string = null;
        String string2 = null;
        while ((string == null || string2 == null) && hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            if (hierarchicalStreamReader.getNodeName().equals("name")) {
                string = hierarchicalStreamReader.getValue();
            } else if (hierarchicalStreamReader.getNodeName().equals("clazz")) {
                string2 = hierarchicalStreamReader.getValue();
            }
            hierarchicalStreamReader.moveUp();
        }
        Class clazz = (Class)this.javaClassConverter.fromString(string2);
        try {
            return clazz.getDeclaredField(this.mapper.realMember(clazz, string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ConversionException(noSuchFieldException);
        }
    }
}

