/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class JavaMethodConverter
implements Converter {
    private final SingleValueConverter javaClassConverter;

    public JavaMethodConverter(ClassLoaderReference classLoaderReference) {
        this(new JavaClassConverter(classLoaderReference));
    }

    public JavaMethodConverter(ClassLoader classLoader) {
        this(new ClassLoaderReference(classLoader));
    }

    protected JavaMethodConverter(SingleValueConverter singleValueConverter) {
        this.javaClassConverter = singleValueConverter;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Method.class) || clazz.equals(Constructor.class);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        if (object instanceof Method) {
            Method method = (Method)object;
            String string = this.javaClassConverter.toString(method.getDeclaringClass());
            this.marshalMethod(hierarchicalStreamWriter, string, method.getName(), method.getParameterTypes());
        } else {
            Constructor constructor = (Constructor)object;
            String string = this.javaClassConverter.toString(constructor.getDeclaringClass());
            this.marshalMethod(hierarchicalStreamWriter, string, null, constructor.getParameterTypes());
        }
    }

    private void marshalMethod(HierarchicalStreamWriter hierarchicalStreamWriter, String string, String string2, Class[] classArray) {
        hierarchicalStreamWriter.startNode("class");
        hierarchicalStreamWriter.setValue(string);
        hierarchicalStreamWriter.endNode();
        if (string2 != null) {
            hierarchicalStreamWriter.startNode("name");
            hierarchicalStreamWriter.setValue(string2);
            hierarchicalStreamWriter.endNode();
        }
        hierarchicalStreamWriter.startNode("parameter-types");
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            hierarchicalStreamWriter.startNode("class");
            hierarchicalStreamWriter.setValue(this.javaClassConverter.toString(classArray[i2]));
            hierarchicalStreamWriter.endNode();
        }
        hierarchicalStreamWriter.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        try {
            Class[] classArray;
            boolean bl2 = unmarshallingContext.getRequiredType().equals(Method.class);
            hierarchicalStreamReader.moveDown();
            String string = hierarchicalStreamReader.getValue();
            Class clazz = (Class)this.javaClassConverter.fromString(string);
            hierarchicalStreamReader.moveUp();
            String string2 = null;
            if (bl2) {
                hierarchicalStreamReader.moveDown();
                string2 = hierarchicalStreamReader.getValue();
                hierarchicalStreamReader.moveUp();
            }
            hierarchicalStreamReader.moveDown();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (hierarchicalStreamReader.hasMoreChildren()) {
                hierarchicalStreamReader.moveDown();
                classArray = hierarchicalStreamReader.getValue();
                arrayList.add(this.javaClassConverter.fromString((String)classArray));
                hierarchicalStreamReader.moveUp();
            }
            classArray = arrayList.toArray(new Class[arrayList.size()]);
            hierarchicalStreamReader.moveUp();
            if (bl2) {
                return clazz.getDeclaredMethod(string2, classArray);
            }
            return clazz.getDeclaredConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ConversionException(noSuchMethodException);
        }
    }
}

