/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.lang.reflect.Array;
import java.util.ArrayList;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import zz.com.thoughtworks.xstream.core.util.Primitives;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class NamedArrayConverter
implements Converter {
    private final Class arrayType;
    private final String itemName;
    private final Mapper mapper;

    public NamedArrayConverter(Class clazz, Mapper mapper, String string) {
        if (!clazz.isArray()) {
            throw new IllegalArgumentException(clazz.getName() + " is not an array");
        }
        this.arrayType = clazz;
        this.mapper = mapper;
        this.itemName = string;
    }

    public boolean canConvert(Class clazz) {
        return clazz == this.arrayType;
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        int n2 = Array.getLength(object);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            Object object2 = Array.get(object, i2);
            Class<Mapper.Null> clazz = object2 == null ? Mapper.Null.class : (this.arrayType.getComponentType().isPrimitive() ? Primitives.unbox(object2.getClass()) : object2.getClass());
            ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, this.itemName, clazz);
            if (!clazz.equals(this.arrayType.getComponentType()) && (string = this.mapper.aliasForSystemAttribute("class")) != null) {
                hierarchicalStreamWriter.addAttribute(string, this.mapper.serializedClass(clazz));
            }
            if (object2 != null) {
                marshallingContext.convertAnother(object2);
            }
            hierarchicalStreamWriter.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            String string = HierarchicalStreams.readClassAttribute(hierarchicalStreamReader, this.mapper);
            Class clazz = string == null ? this.arrayType.getComponentType() : this.mapper.realClass(string);
            object = Mapper.Null.class.equals((Object)clazz) ? null : unmarshallingContext.convertAnother(null, clazz);
            arrayList.add(object);
            hierarchicalStreamReader.moveUp();
        }
        object = Array.newInstance(this.arrayType.getComponentType(), arrayList.size());
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Array.set(object, i2, arrayList.get(i2));
        }
        return object;
    }
}

