/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.util.Map;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.collections.MapConverter;
import zz.com.thoughtworks.xstream.converters.extended.UseAttributeForEnumMapper;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class NamedMapConverter
extends MapConverter {
    private final String entryName;
    private final String keyName;
    private final Class keyType;
    private final String valueName;
    private final Class valueType;
    private final boolean keyAsAttribute;
    private final boolean valueAsAttribute;
    private final ConverterLookup lookup;
    private final Mapper enumMapper;

    public NamedMapConverter(Mapper mapper, String string, String string2, Class clazz, String string3, Class clazz2) {
        this(mapper, string, string2, clazz, string3, clazz2, false, false, null);
    }

    public NamedMapConverter(Class clazz, Mapper mapper, String string, String string2, Class clazz2, String string3, Class clazz3) {
        this(clazz, mapper, string, string2, clazz2, string3, clazz3, false, false, null);
    }

    public NamedMapConverter(Mapper mapper, String string, String string2, Class clazz, String string3, Class clazz2, boolean bl2, boolean bl3, ConverterLookup converterLookup) {
        this(null, mapper, string, string2, clazz, string3, clazz2, bl2, bl3, converterLookup);
    }

    public NamedMapConverter(Class clazz, Mapper mapper, String string, String string2, Class clazz2, String string3, Class clazz3, boolean bl2, boolean bl3, ConverterLookup converterLookup) {
        super(mapper, clazz);
        this.entryName = string != null && string.length() == 0 ? null : string;
        this.keyName = string2 != null && string2.length() == 0 ? null : string2;
        this.keyType = clazz2;
        this.valueName = string3 != null && string3.length() == 0 ? null : string3;
        this.valueType = clazz3;
        this.keyAsAttribute = bl2;
        this.valueAsAttribute = bl3;
        this.lookup = converterLookup;
        Mapper mapper2 = this.enumMapper = JVM.is15() ? UseAttributeForEnumMapper.createEnumMapper(mapper) : null;
        if (clazz2 == null || clazz3 == null) {
            throw new IllegalArgumentException("Class types of key and value are mandatory");
        }
        if (string == null) {
            if (bl2 || bl3) {
                throw new IllegalArgumentException("Cannot write attributes to map entry, if map entry must be omitted");
            }
            if (string3 == null) {
                throw new IllegalArgumentException("Cannot write value as text of entry, if entry must be omitted");
            }
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Cannot write key without name");
        }
        if (string3 == null) {
            if (bl3) {
                throw new IllegalArgumentException("Cannot write value as attribute without name");
            }
            if (!bl2) {
                throw new IllegalArgumentException("Cannot write value as text of entry, if key is also child element");
            }
        }
        if (bl2 && bl3 && string2.equals(string3)) {
            throw new IllegalArgumentException("Cannot write key and value with same attribute name");
        }
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Map map = (Map)object;
        SingleValueConverter singleValueConverter = null;
        SingleValueConverter singleValueConverter2 = null;
        if (this.keyAsAttribute) {
            singleValueConverter = this.getSingleValueConverter(this.keyType, "key");
        }
        if (this.valueAsAttribute || this.valueName == null) {
            singleValueConverter2 = this.getSingleValueConverter(this.valueType, "value");
        }
        for (Map.Entry entry : map.entrySet()) {
            Object k2 = entry.getKey();
            Object v2 = entry.getValue();
            if (this.entryName != null) {
                ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, this.entryName, entry.getClass());
                if (singleValueConverter != null && k2 != null) {
                    hierarchicalStreamWriter.addAttribute(this.keyName, singleValueConverter.toString(k2));
                }
                if (this.valueName != null && singleValueConverter2 != null && v2 != null) {
                    hierarchicalStreamWriter.addAttribute(this.valueName, singleValueConverter2.toString(v2));
                }
            }
            if (singleValueConverter == null) {
                this.writeItem(this.keyName, this.keyType, k2, marshallingContext, hierarchicalStreamWriter);
            }
            if (singleValueConverter2 == null) {
                this.writeItem(this.valueName, this.valueType, v2, marshallingContext, hierarchicalStreamWriter);
            } else if (this.valueName == null) {
                hierarchicalStreamWriter.setValue(singleValueConverter2.toString(v2));
            }
            if (this.entryName == null) continue;
            hierarchicalStreamWriter.endNode();
        }
    }

    protected void populateMap(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Map map, Map map2) {
        SingleValueConverter singleValueConverter = null;
        SingleValueConverter singleValueConverter2 = null;
        if (this.keyAsAttribute) {
            singleValueConverter = this.getSingleValueConverter(this.keyType, "key");
        }
        if (this.valueAsAttribute || this.valueName == null) {
            singleValueConverter2 = this.getSingleValueConverter(this.valueType, "value");
        }
        while (hierarchicalStreamReader.hasMoreChildren()) {
            Object object = null;
            Object object2 = null;
            if (this.entryName != null) {
                String string;
                hierarchicalStreamReader.moveDown();
                if (singleValueConverter != null && (string = hierarchicalStreamReader.getAttribute(this.keyName)) != null) {
                    object = singleValueConverter.fromString(string);
                }
                if (this.valueAsAttribute && singleValueConverter2 != null && (string = hierarchicalStreamReader.getAttribute(this.valueName)) != null) {
                    object2 = singleValueConverter2.fromString(string);
                }
            }
            if (singleValueConverter == null) {
                hierarchicalStreamReader.moveDown();
                if (singleValueConverter2 == null && !this.keyName.equals(this.valueName) && hierarchicalStreamReader.getNodeName().equals(this.valueName)) {
                    object2 = this.readItem(this.valueType, hierarchicalStreamReader, unmarshallingContext, map);
                } else {
                    object = this.readItem(this.keyType, hierarchicalStreamReader, unmarshallingContext, map);
                }
                hierarchicalStreamReader.moveUp();
            }
            if (singleValueConverter2 == null) {
                hierarchicalStreamReader.moveDown();
                if (singleValueConverter == null && object == null && object2 != null) {
                    object = this.readItem(this.keyType, hierarchicalStreamReader, unmarshallingContext, map);
                } else {
                    object2 = this.readItem(this.valueType, hierarchicalStreamReader, unmarshallingContext, map);
                }
                hierarchicalStreamReader.moveUp();
            } else if (!this.valueAsAttribute) {
                object2 = singleValueConverter2.fromString(hierarchicalStreamReader.getValue());
            }
            map2.put(object, object2);
            if (this.entryName == null) continue;
            hierarchicalStreamReader.moveUp();
        }
    }

    private SingleValueConverter getSingleValueConverter(Class clazz, String string) {
        SingleValueConverter singleValueConverter;
        SingleValueConverter singleValueConverter2 = singleValueConverter = UseAttributeForEnumMapper.isEnum(clazz) ? this.enumMapper.getConverterFromItemType(null, clazz, null) : this.mapper().getConverterFromItemType(null, clazz, null);
        if (singleValueConverter == null) {
            Converter converter = this.lookup.lookupConverterForType(clazz);
            if (converter instanceof SingleValueConverter) {
                singleValueConverter = (SingleValueConverter)((Object)converter);
            } else {
                throw new ConversionException("No SingleValueConverter for " + string + " available");
            }
        }
        return singleValueConverter;
    }

    protected void writeItem(String string, Class clazz, Object object, MarshallingContext marshallingContext, HierarchicalStreamWriter hierarchicalStreamWriter) {
        String string2;
        Class clazz2 = object == null ? Mapper.Null.class : object.getClass();
        ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, string, clazz2);
        if (!clazz2.equals(clazz) && (string2 = this.mapper().aliasForSystemAttribute("class")) != null) {
            hierarchicalStreamWriter.addAttribute(string2, this.mapper().serializedClass(clazz2));
        }
        if (object != null) {
            marshallingContext.convertAnother(object);
        }
        hierarchicalStreamWriter.endNode();
    }

    protected Object readItem(Class clazz, HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Object object) {
        Class clazz2;
        String string = HierarchicalStreams.readClassAttribute(hierarchicalStreamReader, this.mapper());
        Class clazz3 = clazz2 = string == null ? clazz : this.mapper().realClass(string);
        if (Mapper.Null.class.equals((Object)clazz2)) {
            return null;
        }
        return unmarshallingContext.convertAnother(object, clazz2);
    }
}

