/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;

public class PathConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class clazz) {
        return Path.class.isAssignableFrom(clazz);
    }

    public Path fromString(String string) {
        try {
            URI uRI = new URI(string);
            if (uRI.getScheme() == null) {
                return Paths.get(string, new String[0]);
            }
            return Paths.get(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return Paths.get(string, new String[0]);
        }
    }

    public String toString(Object object) {
        Path path = (Path)object;
        if (path.getFileSystem() == FileSystems.getDefault()) {
            String string = path.toString();
            if (File.separatorChar != '/') {
                return string.replace(File.separatorChar, '/');
            }
            return string;
        }
        return path.toUri().toString();
    }
}

