/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.TimeZone;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import zz.com.thoughtworks.xstream.core.util.ThreadSafeSimpleDateFormat;

public class SqlTimestampConverter
extends AbstractSingleValueConverter {
    private final ThreadSafeSimpleDateFormat format;

    public SqlTimestampConverter() {
        this(TimeZone.getTimeZone("UTC"));
    }

    public SqlTimestampConverter(TimeZone timeZone) {
        this.format = new ThreadSafeSimpleDateFormat("yyyy-MM-dd HH:mm:ss", timeZone, 0, 5, false);
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Timestamp.class);
    }

    public String toString(Object object) {
        Timestamp timestamp = (Timestamp)object;
        StringBuffer stringBuffer = new StringBuffer(this.format.format(timestamp));
        if (timestamp.getNanos() != 0) {
            int n2;
            stringBuffer.append('.');
            String string = String.valueOf(timestamp.getNanos() + 1000000000);
            for (n2 = 10; n2 > 2 && string.charAt(n2 - 1) == '0'; --n2) {
            }
            stringBuffer.append(string.subSequence(1, n2));
        }
        return stringBuffer.toString();
    }

    public Object fromString(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 > 0 && (string.length() - n2 < 2 || string.length() - n2 > 10)) {
            throw new ConversionException("Timestamp format must be yyyy-mm-dd hh:mm:ss[.fffffffff]");
        }
        try {
            Timestamp timestamp = new Timestamp(this.format.parse(n2 < 0 ? string : string.substring(0, n2)).getTime());
            if (n2 > 0) {
                StringBuffer stringBuffer = new StringBuffer(string.substring(n2 + 1));
                while (stringBuffer.length() != 9) {
                    stringBuffer.append('0');
                }
                timestamp.setNanos(Integer.parseInt(stringBuffer.toString()));
            }
            return timestamp;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConversionException("Timestamp format must be yyyy-mm-dd hh:mm:ss[.fffffffff]", numberFormatException);
        }
        catch (ParseException parseException) {
            throw new ConversionException("Timestamp format must be yyyy-mm-dd hh:mm:ss[.fffffffff]", parseException);
        }
    }
}

