/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import zz.com.thoughtworks.xstream.converters.extended.StackTraceElementFactory;
import zz.com.thoughtworks.xstream.core.JVM;

public class StackTraceElementConverter
extends AbstractSingleValueConverter {
    private static final Pattern PATTERN = Pattern.compile("^(.+)\\.([^\\(]+)\\(([^:]*)(:(\\d+))?\\)$");
    private static final StackTraceElementFactory FACTORY;

    public boolean canConvert(Class clazz) {
        return StackTraceElement.class.equals((Object)clazz) && FACTORY != null;
    }

    public String toString(Object object) {
        String string = super.toString(object);
        return string.replaceFirst(":\\?\\?\\?", "");
    }

    public Object fromString(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            if (string4.equals("Unknown Source")) {
                return FACTORY.unknownSourceElement(string2, string3);
            }
            if (string4.equals("Native Method")) {
                return FACTORY.nativeMethodElement(string2, string3);
            }
            if (matcher.group(4) != null) {
                int n2 = Integer.parseInt(matcher.group(5));
                return FACTORY.element(string2, string3, string4, n2);
            }
            return FACTORY.element(string2, string3, string4);
        }
        throw new ConversionException("Could not parse StackTraceElement : " + string);
    }

    static {
        StackTraceElementFactory stackTraceElementFactory = null;
        if (JVM.is15()) {
            Class clazz = JVM.loadClassForName("zz.com.thoughtworks.xstream.converters.extended.StackTraceElementFactory15", false);
            try {
                stackTraceElementFactory = (StackTraceElementFactory)clazz.newInstance();
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        if (stackTraceElementFactory == null) {
            stackTraceElementFactory = new StackTraceElementFactory();
        }
        try {
            stackTraceElementFactory.unknownSourceElement("a", "b");
        }
        catch (Exception exception) {
            stackTraceElementFactory = null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            stackTraceElementFactory = null;
        }
        FACTORY = stackTraceElementFactory;
    }
}

