/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class SubjectConverter
extends AbstractCollectionConverter {
    public SubjectConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Subject.class);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Subject subject = (Subject)object;
        this.marshalPrincipals(subject.getPrincipals(), hierarchicalStreamWriter, marshallingContext);
        this.marshalPublicCredentials(subject.getPublicCredentials(), hierarchicalStreamWriter, marshallingContext);
        this.marshalPrivateCredentials(subject.getPrivateCredentials(), hierarchicalStreamWriter, marshallingContext);
        this.marshalReadOnly(subject.isReadOnly(), hierarchicalStreamWriter);
    }

    protected void marshalPrincipals(Set set, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        hierarchicalStreamWriter.startNode("principals");
        for (Object e2 : set) {
            this.writeItem(e2, marshallingContext, hierarchicalStreamWriter);
        }
        hierarchicalStreamWriter.endNode();
    }

    protected void marshalPublicCredentials(Set set, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
    }

    protected void marshalPrivateCredentials(Set set, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
    }

    protected void marshalReadOnly(boolean bl2, HierarchicalStreamWriter hierarchicalStreamWriter) {
        hierarchicalStreamWriter.startNode("readOnly");
        hierarchicalStreamWriter.setValue(String.valueOf(bl2));
        hierarchicalStreamWriter.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Set set = this.unmarshalPrincipals(hierarchicalStreamReader, unmarshallingContext);
        Set set2 = this.unmarshalPublicCredentials(hierarchicalStreamReader, unmarshallingContext);
        Set set3 = this.unmarshalPrivateCredentials(hierarchicalStreamReader, unmarshallingContext);
        boolean bl2 = this.unmarshalReadOnly(hierarchicalStreamReader);
        return new Subject(bl2, set, set2, set3);
    }

    protected Set unmarshalPrincipals(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        return this.populateSet(hierarchicalStreamReader, unmarshallingContext);
    }

    protected Set unmarshalPublicCredentials(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        return Collections.EMPTY_SET;
    }

    protected Set unmarshalPrivateCredentials(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        return Collections.EMPTY_SET;
    }

    protected boolean unmarshalReadOnly(HierarchicalStreamReader hierarchicalStreamReader) {
        hierarchicalStreamReader.moveDown();
        boolean bl2 = Boolean.getBoolean(hierarchicalStreamReader.getValue());
        hierarchicalStreamReader.moveUp();
        return bl2;
    }

    protected Set populateSet(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hierarchicalStreamReader.moveDown();
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            Object object = this.readItem(hierarchicalStreamReader, unmarshallingContext, hashSet);
            hierarchicalStreamReader.moveUp();
            hashSet.add(object);
        }
        hierarchicalStreamReader.moveUp();
        return hashSet;
    }
}

