/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class ThrowableConverter
implements Converter {
    private Converter defaultConverter;
    private final ConverterLookup lookup;

    public ThrowableConverter(Converter converter) {
        this.defaultConverter = converter;
        this.lookup = null;
    }

    public ThrowableConverter(ConverterLookup converterLookup) {
        this.lookup = converterLookup;
    }

    public boolean canConvert(Class clazz) {
        return Throwable.class.isAssignableFrom(clazz);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Throwable throwable = (Throwable)object;
        if (throwable.getCause() == null) {
            try {
                throwable.initCause(null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        throwable.getStackTrace();
        this.getConverter().marshal(throwable, hierarchicalStreamWriter, marshallingContext);
    }

    private Converter getConverter() {
        return this.defaultConverter != null ? this.defaultConverter : this.lookup.lookupConverterForType(Object.class);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        return this.getConverter().unmarshal(hierarchicalStreamReader, unmarshallingContext);
    }
}

