/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.ErrorWritingException;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.extended.UseAttributeForEnumMapper;
import zz.com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.util.FastField;
import zz.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import zz.com.thoughtworks.xstream.core.util.Primitives;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class ToAttributedValueConverter
implements Converter {
    private static final String STRUCTURE_MARKER = "";
    private final Class type;
    private final Mapper mapper;
    private final Mapper enumMapper;
    private final ReflectionProvider reflectionProvider;
    private final ConverterLookup lookup;
    private final Field valueField;

    public ToAttributedValueConverter(Class clazz, Mapper mapper, ReflectionProvider reflectionProvider, ConverterLookup converterLookup) {
        this(clazz, mapper, reflectionProvider, converterLookup, null, null);
    }

    public ToAttributedValueConverter(Class clazz, Mapper mapper, ReflectionProvider reflectionProvider, ConverterLookup converterLookup, String string) {
        this(clazz, mapper, reflectionProvider, converterLookup, string, null);
    }

    public ToAttributedValueConverter(Class clazz, Mapper mapper, ReflectionProvider reflectionProvider, ConverterLookup converterLookup, String string, Class clazz2) {
        this.type = clazz;
        this.mapper = mapper;
        this.reflectionProvider = reflectionProvider;
        this.lookup = converterLookup;
        if (string == null) {
            this.valueField = null;
        } else {
            Field field = null;
            try {
                field = (clazz2 != null ? clazz2 : clazz).getDeclaredField(string);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalArgumentException(noSuchFieldException.getMessage() + ": " + string);
            }
            this.valueField = field;
        }
        this.enumMapper = JVM.is15() ? UseAttributeForEnumMapper.createEnumMapper(mapper) : null;
    }

    public boolean canConvert(Class clazz) {
        return this.type == clazz;
    }

    public void marshal(Object object, final HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        final Class<?> clazz = object.getClass();
        final HashMap hashMap = new HashMap();
        final String[] stringArray = new String[1];
        final Object[] objectArray = new Object[1];
        final Class[] classArray = new Class[1];
        final Class[] classArray2 = new Class[1];
        this.reflectionProvider.visitSerializableFields(object, new ReflectionProvider.Visitor(){

            public void visit(String string, Class clazz3, Class clazz2, Object object) {
                Object object2;
                if (!ToAttributedValueConverter.this.mapper.shouldSerializeMember(clazz2, string)) {
                    return;
                }
                FastField fastField = new FastField(clazz2, string);
                String string2 = ToAttributedValueConverter.this.mapper.serializedMember(clazz2, string);
                if (!hashMap.containsKey(string2)) {
                    object2 = clazz;
                    hashMap.put(string2, ToAttributedValueConverter.this.reflectionProvider.getField((Class)object2, string));
                } else if (!ToAttributedValueConverter.this.fieldIsEqual(fastField)) {
                    ConversionException conversionException = new ConversionException("Cannot write attribute twice for object");
                    conversionException.add("alias", string2);
                    conversionException.add("type", clazz.getName());
                    throw conversionException;
                }
                Object object3 = object2 = UseAttributeForEnumMapper.isEnum(clazz3) ? ToAttributedValueConverter.this.enumMapper.getConverterFromItemType(null, clazz3, null) : ToAttributedValueConverter.this.mapper.getLocalConverter(clazz2, string);
                if (object2 == null) {
                    object2 = ToAttributedValueConverter.this.lookup.lookupConverterForType(clazz3);
                }
                if (object != null) {
                    boolean bl2;
                    boolean bl3 = bl2 = ToAttributedValueConverter.this.valueField != null && ToAttributedValueConverter.this.fieldIsEqual(fastField);
                    if (bl2) {
                        classArray2[0] = clazz2;
                        classArray[0] = clazz3;
                        objectArray[0] = object;
                        stringArray[0] = ToAttributedValueConverter.STRUCTURE_MARKER;
                    }
                    if (object2 instanceof SingleValueConverter) {
                        String string3 = ((SingleValueConverter)object2).toString(object);
                        if (bl2) {
                            stringArray[0] = string3;
                        } else if (string3 != null) {
                            hierarchicalStreamWriter.addAttribute(string2, string3);
                        }
                    } else if (!bl2) {
                        ConversionException conversionException = new ConversionException("Cannot write element as attribute");
                        conversionException.add("alias", string2);
                        conversionException.add("type", clazz.getName());
                        throw conversionException;
                    }
                }
            }
        });
        if (stringArray[0] != null) {
            String string;
            String string2;
            Class clazz2;
            Class<?> clazz3 = objectArray[0].getClass();
            if (!clazz3.equals(clazz2 = this.mapper.defaultImplementationOf(classArray[0])) && !(string2 = this.mapper.serializedClass(clazz3)).equals(this.mapper.serializedClass(clazz2)) && (string = this.mapper.aliasForSystemAttribute("class")) != null) {
                hierarchicalStreamWriter.addAttribute(string, string2);
            }
            if (stringArray[0] == STRUCTURE_MARKER) {
                marshallingContext.convertAnother(objectArray[0]);
            } else {
                hierarchicalStreamWriter.setValue(stringArray[0]);
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Field field;
        Object object5;
        Object object6 = this.reflectionProvider.newInstance(unmarshallingContext.getRequiredType());
        Class<?> clazz = object6.getClass();
        HashSet<FastField> hashSet = new HashSet<FastField>();
        Iterator iterator = hierarchicalStreamReader.getAttributeNames();
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add(this.mapper.aliasForSystemAttribute("class"));
        while (iterator.hasNext()) {
            object5 = (String)iterator.next();
            if (hashSet2.contains(object5) || (field = this.reflectionProvider.getFieldOrNull(clazz, string = this.mapper.realMember(clazz, (String)object5))) == null || Modifier.isTransient(field.getModifiers())) continue;
            object4 = field.getType();
            object3 = field.getDeclaringClass();
            Object object7 = object2 = UseAttributeForEnumMapper.isEnum((Class)object4) ? this.enumMapper.getConverterFromItemType(null, (Class)object4, null) : this.mapper.getLocalConverter((Class)object3, string);
            if (object2 == null) {
                object2 = this.lookup.lookupConverterForType((Class)object4);
            }
            if (!(object2 instanceof SingleValueConverter)) {
                object = new ConversionException("Cannot read field as a single value for object");
                ((ErrorWritingException)object).add("field", string);
                ((ErrorWritingException)object).add("type", clazz.getName());
                throw object;
            }
            if (object2 == null) continue;
            object = ((SingleValueConverter)object2).fromString(hierarchicalStreamReader.getAttribute((String)object5));
            if (((Class)object4).isPrimitive()) {
                object4 = Primitives.box((Class)object4);
            }
            if (object != null && !((Class)object4).isAssignableFrom(object.getClass())) {
                ConversionException conversionException = new ConversionException("Cannot assign object to type");
                conversionException.add("object type", object.getClass().getName());
                conversionException.add("target type", ((Class)object4).getName());
                throw conversionException;
            }
            this.reflectionProvider.writeField(object6, string, object, (Class)object3);
            if (hashSet.add(new FastField((Class)object3, string))) continue;
            throw new AbstractReflectionConverter.DuplicateFieldException(string + " [" + ((Class)object3).getName() + "]");
        }
        if (this.valueField != null) {
            object5 = this.valueField.getDeclaringClass();
            string = this.valueField.getName();
            Field field2 = field = string == null ? null : this.reflectionProvider.getField((Class)object5, string);
            if (string == null || field == null) {
                object4 = new ConversionException("Cannot assign value to field of type");
                ((ErrorWritingException)object4).add("element", hierarchicalStreamReader.getNodeName());
                ((ErrorWritingException)object4).add("field", string);
                ((ErrorWritingException)object4).add("target type", unmarshallingContext.getRequiredType().getName());
                throw object4;
            }
            object3 = HierarchicalStreams.readClassAttribute(hierarchicalStreamReader, this.mapper);
            object4 = object3 != null ? this.mapper.realClass((String)object3) : this.mapper.defaultImplementationOf(this.reflectionProvider.getFieldType(object6, string, (Class)object5));
            object2 = unmarshallingContext.convertAnother(object6, (Class)object4, this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName()));
            object = this.reflectionProvider.getFieldType(object6, string, (Class)object5);
            if (!((Class)object).isPrimitive()) {
                object4 = object;
            }
            if (object2 != null && !((Class)object4).isAssignableFrom(object2.getClass())) {
                ConversionException conversionException = new ConversionException("Cannot assign object to type");
                conversionException.add("object type", object2.getClass().getName());
                conversionException.add("target type", ((Class)object4).getName());
                throw conversionException;
            }
            this.reflectionProvider.writeField(object6, string, object2, (Class)object5);
            if (!hashSet.add(new FastField((Class)object5, string))) {
                throw new AbstractReflectionConverter.DuplicateFieldException(string + " [" + ((Class)object5).getName() + "]");
            }
        }
        return object6;
    }

    private boolean fieldIsEqual(FastField fastField) {
        return this.valueField.getName().equals(fastField.getName()) && this.valueField.getDeclaringClass().getName().equals(fastField.getDeclaringClass());
    }
}

