/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.extended;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;

public class ToStringConverter
extends AbstractSingleValueConverter {
    private static final Class[] STRING_PARAMETER = new Class[]{String.class};
    private final Class clazz;
    private final Constructor ctor;

    public ToStringConverter(Class clazz) throws NoSuchMethodException {
        this.clazz = clazz;
        this.ctor = clazz.getConstructor(STRING_PARAMETER);
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(this.clazz);
    }

    public String toString(Object object) {
        return object == null ? null : object.toString();
    }

    public Object fromString(String string) {
        try {
            return this.ctor.newInstance(string);
        }
        catch (InstantiationException instantiationException) {
            throw new ConversionException("Unable to instantiate single String param constructor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectAccessException("Unable to access single String param constructor", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConversionException("Unable to target single String param constructor", invocationTargetException.getTargetException());
        }
    }
}

