/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.javabean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;

public class BeanProperty {
    private Class memberClass;
    private String propertyName;
    private Class type;
    protected Method getter;
    private Method setter;
    private static final Object[] EMPTY_ARGS = new Object[0];

    public BeanProperty(Class clazz, String string, Class clazz2) {
        this.memberClass = clazz;
        this.propertyName = string;
        this.type = clazz2;
    }

    public Class getBeanClass() {
        return this.memberClass;
    }

    public Class getType() {
        return this.type;
    }

    public String getName() {
        return this.propertyName;
    }

    public boolean isReadable() {
        return this.getter != null;
    }

    public boolean isWritable() {
        return this.setter != null;
    }

    public Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.isReadable()) {
            throw new IllegalStateException("Property " + this.propertyName + " of " + this.memberClass + " not readable");
        }
        try {
            return this.getter.invoke(object, EMPTY_ARGS);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UndeclaredThrowableException(invocationTargetException.getTargetException());
        }
    }

    public Object set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        if (!this.isWritable()) {
            throw new IllegalStateException("Property " + this.propertyName + " of " + this.memberClass + " not writable");
        }
        try {
            return this.setter.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UndeclaredThrowableException(invocationTargetException.getTargetException());
        }
    }

    public void setGetterMethod(Method method) {
        this.getter = method;
    }

    public void setSetterMethod(Method method) {
        this.setter = method;
    }
}

