/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.javabean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.ErrorWritingException;
import zz.com.thoughtworks.xstream.converters.javabean.ComparingPropertySorter;
import zz.com.thoughtworks.xstream.converters.javabean.JavaBeanProvider;
import zz.com.thoughtworks.xstream.converters.javabean.NativePropertySorter;
import zz.com.thoughtworks.xstream.converters.javabean.PropertyDictionary;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;

public class BeanProvider
implements JavaBeanProvider {
    protected static final Object[] NO_PARAMS = new Object[0];
    protected PropertyDictionary propertyDictionary;

    public BeanProvider() {
        this(new PropertyDictionary(new NativePropertySorter()));
    }

    public BeanProvider(Comparator comparator) {
        this(new PropertyDictionary(new ComparingPropertySorter(comparator)));
    }

    public BeanProvider(PropertyDictionary propertyDictionary) {
        this.propertyDictionary = propertyDictionary;
    }

    public Object newInstance(Class clazz) {
        ErrorWritingException errorWritingException = null;
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            errorWritingException = new ConversionException("Cannot construct type", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            errorWritingException = new ObjectAccessException("Cannot construct type", illegalAccessException);
        }
        catch (SecurityException securityException) {
            errorWritingException = new ObjectAccessException("Cannot construct type", securityException);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            errorWritingException = new ConversionException("Cannot construct type", exceptionInInitializerError);
        }
        errorWritingException.add("construction-type", clazz.getName());
        throw errorWritingException;
    }

    public void visitSerializableProperties(Object object, JavaBeanProvider.Visitor visitor) {
        PropertyDescriptor[] propertyDescriptorArray = this.getSerializableProperties(object);
        for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
            ErrorWritingException errorWritingException = null;
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i2];
            try {
                Method method = propertyDescriptor.getReadMethod();
                String string = propertyDescriptor.getName();
                Class<?> clazz = method.getDeclaringClass();
                if (visitor.shouldVisit(string, clazz)) {
                    Object object2 = method.invoke(object, new Object[0]);
                    visitor.visit(string, propertyDescriptor.getPropertyType(), clazz, object2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errorWritingException = new ConversionException("Cannot get property", illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                errorWritingException = new ObjectAccessException("Cannot access property", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                errorWritingException = new ConversionException("Cannot get property", invocationTargetException.getTargetException());
            }
            if (errorWritingException == null) continue;
            errorWritingException.add("property", object.getClass() + "." + propertyDescriptor.getName());
            throw errorWritingException;
        }
    }

    public void writeProperty(Object object, String string, Object object2) {
        ErrorWritingException errorWritingException = null;
        PropertyDescriptor propertyDescriptor = this.getProperty(string, object.getClass());
        try {
            propertyDescriptor.getWriteMethod().invoke(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorWritingException = new ConversionException("Cannot set property", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            errorWritingException = new ObjectAccessException("Cannot access property", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            errorWritingException = new ConversionException("Cannot set property", invocationTargetException.getTargetException());
        }
        if (errorWritingException != null) {
            errorWritingException.add("property", object.getClass() + "." + propertyDescriptor.getName());
            throw errorWritingException;
        }
    }

    public Class getPropertyType(Object object, String string) {
        return this.getProperty(string, object.getClass()).getPropertyType();
    }

    public boolean propertyDefinedInClass(String string, Class clazz) {
        return this.propertyDictionary.propertyDescriptorOrNull(clazz, string) != null;
    }

    public boolean canInstantiate(Class clazz) {
        try {
            return clazz != null && this.newInstance(clazz) != null;
        }
        catch (ErrorWritingException errorWritingException) {
            return false;
        }
    }

    protected Constructor getDefaultConstrutor(Class clazz) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i2 = 0; i2 < constructorArray.length; ++i2) {
            Constructor<?> constructor = constructorArray[i2];
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return constructor;
        }
        return null;
    }

    protected PropertyDescriptor[] getSerializableProperties(Object object) {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        Iterator iterator = this.propertyDictionary.propertiesFor(object.getClass());
        while (iterator.hasNext()) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)iterator.next();
            if (!this.canStreamProperty(propertyDescriptor)) continue;
            arrayList.add(propertyDescriptor);
        }
        return arrayList.toArray(new PropertyDescriptor[arrayList.size()]);
    }

    protected boolean canStreamProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null;
    }

    public boolean propertyWriteable(String string, Class clazz) {
        PropertyDescriptor propertyDescriptor = this.getProperty(string, clazz);
        return propertyDescriptor.getWriteMethod() != null;
    }

    protected PropertyDescriptor getProperty(String string, Class clazz) {
        return this.propertyDictionary.propertyDescriptor(clazz, string);
    }

    public static interface Visitor
    extends JavaBeanProvider.Visitor {
    }
}

