/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.javabean;

import java.util.HashSet;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.javabean.BeanProvider;
import zz.com.thoughtworks.xstream.converters.javabean.JavaBeanProvider;
import zz.com.thoughtworks.xstream.converters.reflection.MissingFieldException;
import zz.com.thoughtworks.xstream.core.util.FastField;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class JavaBeanConverter
implements Converter {
    protected final Mapper mapper;
    protected final JavaBeanProvider beanProvider;
    private final Class type;
    private String classAttributeIdentifier;

    public JavaBeanConverter(Mapper mapper) {
        this(mapper, (Class)null);
    }

    public JavaBeanConverter(Mapper mapper, Class clazz) {
        this(mapper, new BeanProvider(), clazz);
    }

    public JavaBeanConverter(Mapper mapper, JavaBeanProvider javaBeanProvider) {
        this(mapper, javaBeanProvider, null);
    }

    public JavaBeanConverter(Mapper mapper, JavaBeanProvider javaBeanProvider, Class clazz) {
        this.mapper = mapper;
        this.beanProvider = javaBeanProvider;
        this.type = clazz;
    }

    public JavaBeanConverter(Mapper mapper, String string) {
        this(mapper, new BeanProvider());
        this.classAttributeIdentifier = string;
    }

    public boolean canConvert(Class clazz) {
        return (this.type == null || this.type == clazz) && this.beanProvider.canInstantiate(clazz);
    }

    public void marshal(final Object object, final HierarchicalStreamWriter hierarchicalStreamWriter, final MarshallingContext marshallingContext) {
        final String string = this.mapper.aliasForSystemAttribute("class");
        this.beanProvider.visitSerializableProperties(object, new JavaBeanProvider.Visitor(){

            public boolean shouldVisit(String string2, Class clazz) {
                return JavaBeanConverter.this.mapper.shouldSerializeMember(clazz, string2);
            }

            public void visit(String string2, Class clazz, Class clazz2, Object object2) {
                if (object2 != null) {
                    this.writeField(string2, clazz, object2);
                } else {
                    this.writeNullField(string2);
                }
            }

            private void writeField(String string3, Class clazz, Object object2) {
                Class<?> clazz2 = object2.getClass();
                Class clazz3 = JavaBeanConverter.this.mapper.defaultImplementationOf(clazz);
                String string2 = JavaBeanConverter.this.mapper.serializedMember(object.getClass(), string3);
                ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, string2, clazz2);
                if (!clazz2.equals(clazz3) && string != null) {
                    hierarchicalStreamWriter.addAttribute(string, JavaBeanConverter.this.mapper.serializedClass(clazz2));
                }
                marshallingContext.convertAnother(object2);
                hierarchicalStreamWriter.endNode();
            }

            private void writeNullField(String string3) {
                String string2 = JavaBeanConverter.this.mapper.serializedMember(object.getClass(), string3);
                ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, string2, Mapper.Null.class);
                hierarchicalStreamWriter.addAttribute(string, JavaBeanConverter.this.mapper.serializedClass(Mapper.Null.class));
                hierarchicalStreamWriter.endNode();
            }
        });
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Object object = this.instantiateNewInstance(unmarshallingContext);
        HashSet hashSet = new HashSet(){

            public boolean add(Object object) {
                if (!super.add(object)) {
                    throw new DuplicatePropertyException(((FastField)object).getName());
                }
                return true;
            }
        };
        Class<?> clazz = object.getClass();
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            String string = this.mapper.realMember(clazz, hierarchicalStreamReader.getNodeName());
            if (this.mapper.shouldSerializeMember(clazz, string)) {
                boolean bl2 = this.beanProvider.propertyDefinedInClass(string, clazz);
                if (bl2) {
                    Class clazz2 = this.determineType(hierarchicalStreamReader, object, string);
                    Object object2 = unmarshallingContext.convertAnother(object, clazz2);
                    this.beanProvider.writeProperty(object, string, object2);
                    hashSet.add(new FastField(clazz, string));
                } else if (!this.mapper.isIgnoredElement(string)) {
                    throw new MissingFieldException(clazz.getName(), string);
                }
            }
            hierarchicalStreamReader.moveUp();
        }
        return object;
    }

    private Object instantiateNewInstance(UnmarshallingContext unmarshallingContext) {
        Object object = unmarshallingContext.currentObject();
        if (object == null) {
            object = this.beanProvider.newInstance(unmarshallingContext.getRequiredType());
        }
        return object;
    }

    private Class determineType(HierarchicalStreamReader hierarchicalStreamReader, Object object, String string) {
        String string2;
        String string3 = this.classAttributeIdentifier != null ? this.classAttributeIdentifier : this.mapper.aliasForSystemAttribute("class");
        String string4 = string2 = string3 == null ? null : hierarchicalStreamReader.getAttribute(string3);
        if (string2 != null) {
            return this.mapper.realClass(string2);
        }
        return this.mapper.defaultImplementationOf(this.beanProvider.getPropertyType(object, string));
    }

    public static class DuplicatePropertyException
    extends ConversionException {
        public DuplicatePropertyException(String string) {
            super("Duplicate property " + string);
            this.add("property", string);
        }
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String string) {
            super(string);
        }
    }
}

