/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.javabean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.javabean.BeanProperty;
import zz.com.thoughtworks.xstream.converters.javabean.NativePropertySorter;
import zz.com.thoughtworks.xstream.converters.javabean.PropertySorter;
import zz.com.thoughtworks.xstream.converters.reflection.MissingFieldException;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.Caching;
import zz.com.thoughtworks.xstream.core.util.OrderRetainingMap;

public class PropertyDictionary
implements Caching {
    private transient Map propertyNameCache = Collections.synchronizedMap(new HashMap());
    private final PropertySorter sorter;

    public PropertyDictionary() {
        this(new NativePropertySorter());
    }

    public PropertyDictionary(PropertySorter propertySorter) {
        this.sorter = propertySorter;
    }

    public Iterator serializablePropertiesFor(Class clazz) {
        ArrayList<BeanProperty> arrayList = new ArrayList<BeanProperty>();
        Collection collection = this.buildMap(clazz).values();
        for (PropertyDescriptor propertyDescriptor : collection) {
            if (propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null) continue;
            arrayList.add(new BeanProperty(clazz, propertyDescriptor.getName(), propertyDescriptor.getPropertyType()));
        }
        return arrayList.iterator();
    }

    public BeanProperty property(Class clazz, String string) {
        BeanProperty beanProperty = null;
        PropertyDescriptor propertyDescriptor = this.propertyDescriptorOrNull(clazz, string);
        if (propertyDescriptor == null) {
            throw new MissingFieldException(clazz.getName(), string);
        }
        if (propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null) {
            beanProperty = new BeanProperty(clazz, propertyDescriptor.getName(), propertyDescriptor.getPropertyType());
        }
        return beanProperty;
    }

    public Iterator propertiesFor(Class clazz) {
        return this.buildMap(clazz).values().iterator();
    }

    public PropertyDescriptor propertyDescriptor(Class clazz, String string) {
        PropertyDescriptor propertyDescriptor = this.propertyDescriptorOrNull(clazz, string);
        if (propertyDescriptor == null) {
            throw new MissingFieldException(clazz.getName(), string);
        }
        return propertyDescriptor;
    }

    public PropertyDescriptor propertyDescriptorOrNull(Class clazz, String string) {
        return (PropertyDescriptor)this.buildMap(clazz).get(string);
    }

    private Map buildMap(Class clazz) {
        Map map = (Map)this.propertyNameCache.get(clazz);
        if (map == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(clazz, Object.class);
            }
            catch (IntrospectionException introspectionException) {
                ObjectAccessException objectAccessException = new ObjectAccessException("Cannot get BeanInfo of type", introspectionException);
                objectAccessException.add("bean-type", clazz.getName());
                throw objectAccessException;
            }
            map = new OrderRetainingMap();
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i2];
                map.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            map = this.sorter.sort(clazz, map);
            this.propertyNameCache.put(clazz, map);
        }
        return map;
    }

    public void flushCache() {
        this.propertyNameCache.clear();
    }
}

