/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.util.Fields;

public class AbstractAttributedCharacterIteratorAttributeConverter
extends AbstractSingleValueConverter {
    private static final Map instanceMaps = new HashMap();
    private static final Method getName;
    private final Class type;
    private transient Map attributeMap;

    public AbstractAttributedCharacterIteratorAttributeConverter(Class clazz) {
        if (!AttributedCharacterIterator.Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a " + AttributedCharacterIterator.Attribute.class.getName());
        }
        this.type = clazz;
        this.readResolve();
    }

    public boolean canConvert(Class clazz) {
        return clazz == this.type && !this.attributeMap.isEmpty();
    }

    public String toString(Object object) {
        return this.getName((AttributedCharacterIterator.Attribute)object);
    }

    private String getName(AttributedCharacterIterator.Attribute attribute) {
        String string;
        String string2;
        ReflectiveOperationException reflectiveOperationException = null;
        if (getName != null) {
            try {
                return (String)getName.invoke((Object)attribute, (Object[])null);
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectiveOperationException = illegalAccessException;
            }
            catch (InvocationTargetException invocationTargetException) {
                reflectiveOperationException = invocationTargetException;
            }
        }
        if ((string2 = attribute.toString()).startsWith(string = attribute.getClass().getName())) {
            return string2.substring(string.length() + 1, string2.length() - 1);
        }
        ConversionException conversionException = new ConversionException("Cannot find name of attribute", reflectiveOperationException);
        conversionException.add("attribute-type", string);
        throw conversionException;
    }

    public Object fromString(String string) {
        if (this.attributeMap.containsKey(string)) {
            return this.attributeMap.get(string);
        }
        ConversionException conversionException = new ConversionException("Cannot find attribute");
        conversionException.add("attribute-type", this.type.getName());
        conversionException.add("attribute-name", string);
        throw conversionException;
    }

    private Object readResolve() {
        this.attributeMap = (Map)instanceMaps.get(this.type.getName());
        if (this.attributeMap == null) {
            Object object;
            int n2;
            Field[] fieldArray;
            this.attributeMap = new HashMap();
            Field field = Fields.locate(this.type, Map.class, true);
            if (field != null) {
                try {
                    fieldArray = (Field[])Fields.read(field, null);
                    if (fieldArray != null) {
                        n2 = 1;
                        object = fieldArray.entrySet().iterator();
                        while (n2 != 0 && object.hasNext()) {
                            Map.Entry entry = object.next();
                            n2 = entry.getKey().getClass() == String.class && entry.getValue().getClass() == this.type ? 1 : 0;
                        }
                        if (n2 != 0) {
                            this.attributeMap.putAll(fieldArray);
                        }
                    }
                }
                catch (ObjectAccessException objectAccessException) {
                    // empty catch block
                }
            }
            if (this.attributeMap.isEmpty()) {
                try {
                    fieldArray = this.type.getDeclaredFields();
                    for (n2 = 0; n2 < fieldArray.length; ++n2) {
                        if (fieldArray[n2].getType() == this.type != Modifier.isStatic(fieldArray[n2].getModifiers())) continue;
                        object = (AttributedCharacterIterator.Attribute)Fields.read(fieldArray[n2], null);
                        this.attributeMap.put(this.toString(object), object);
                    }
                }
                catch (SecurityException securityException) {
                    this.attributeMap.clear();
                }
                catch (ObjectAccessException objectAccessException) {
                    this.attributeMap.clear();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    this.attributeMap.clear();
                }
            }
            instanceMaps.put(this.type.getName(), this.attributeMap);
        }
        return this;
    }

    static {
        Method method = null;
        try {
            method = AttributedCharacterIterator.Attribute.class.getDeclaredMethod("getName", null);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getName = method;
    }
}

