/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ErrorWritingException;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.converters.reflection.SerializationMethodInvoker;
import zz.com.thoughtworks.xstream.core.Caching;
import zz.com.thoughtworks.xstream.core.ReferencingMarshallingContext;
import zz.com.thoughtworks.xstream.core.util.ArrayIterator;
import zz.com.thoughtworks.xstream.core.util.FastField;
import zz.com.thoughtworks.xstream.core.util.Fields;
import zz.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import zz.com.thoughtworks.xstream.core.util.Primitives;
import zz.com.thoughtworks.xstream.core.util.SerializationMembers;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.CannotResolveClassException;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public abstract class AbstractReflectionConverter
implements Converter,
Caching {
    protected final ReflectionProvider reflectionProvider;
    protected final Mapper mapper;
    protected transient SerializationMethodInvoker serializationMethodInvoker;
    protected transient SerializationMembers serializationMembers;
    private transient ReflectionProvider pureJavaReflectionProvider;

    public AbstractReflectionConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this.mapper = mapper;
        this.reflectionProvider = reflectionProvider;
        this.serializationMethodInvoker = new SerializationMethodInvoker();
        this.serializationMembers = this.serializationMethodInvoker.serializationMembers;
    }

    protected boolean canAccess(Class clazz) {
        try {
            this.reflectionProvider.getFieldOrNull(clazz, "%");
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Object object2 = this.serializationMembers.callWriteReplace(object);
        if (object2 != object && marshallingContext instanceof ReferencingMarshallingContext) {
            ((ReferencingMarshallingContext)marshallingContext).replace(object, object2);
        }
        if (object2.getClass() != object.getClass()) {
            String string = this.mapper.aliasForSystemAttribute("resolves-to");
            if (string != null) {
                hierarchicalStreamWriter.addAttribute(string, this.mapper.serializedClass(object2.getClass()));
            }
            marshallingContext.convertAnother(object2);
        } else {
            this.doMarshal(object2, hierarchicalStreamWriter, marshallingContext);
        }
    }

    protected void doMarshal(final Object object, final HierarchicalStreamWriter hierarchicalStreamWriter, final MarshallingContext marshallingContext) {
        final ArrayList arrayList = new ArrayList();
        final HashMap hashMap = new HashMap();
        final Class<?> clazz = object.getClass();
        this.reflectionProvider.visitSerializableFields(object, new ReflectionProvider.Visitor(){
            final Set writtenAttributes = new HashSet();

            public void visit(String string, Class clazz3, Class clazz2, Object object3) {
                Object object2;
                if (!AbstractReflectionConverter.this.mapper.shouldSerializeMember(clazz2, string)) {
                    return;
                }
                if (!hashMap.containsKey(string)) {
                    object2 = object.getClass();
                    if (clazz2 != clazz && !AbstractReflectionConverter.this.mapper.shouldSerializeMember((Class)object2, string)) {
                        object2 = clazz2;
                    }
                    hashMap.put(string, AbstractReflectionConverter.this.reflectionProvider.getField((Class)object2, string));
                }
                if ((object2 = AbstractReflectionConverter.this.mapper.getConverterFromItemType(string, clazz3, clazz2)) != null) {
                    String string2 = AbstractReflectionConverter.this.mapper.aliasForAttribute(AbstractReflectionConverter.this.mapper.serializedMember(clazz2, string));
                    if (object3 != null) {
                        if (this.writtenAttributes.contains(string)) {
                            ConversionException conversionException = new ConversionException("Cannot write field as attribute for object, attribute name already in use");
                            conversionException.add("field-name", string);
                            conversionException.add("object-type", clazz.getName());
                            throw conversionException;
                        }
                        String string3 = object2.toString(object3);
                        if (string3 != null) {
                            hierarchicalStreamWriter.addAttribute(string2, string3);
                        }
                    }
                    this.writtenAttributes.add(string);
                } else {
                    arrayList.add(new FieldInfo(string, clazz3, clazz2, object3));
                }
            }
        });
        new Object(){
            {
                HashMap<String, HashSet<Mapper.ImplicitCollectionMapping>> hashMap2 = new HashMap<String, HashSet<Mapper.ImplicitCollectionMapping>>();
                for (FieldInfo fieldInfo : arrayList) {
                    HashSet<Mapper.ImplicitCollectionMapping> hashSet;
                    if (fieldInfo.value == null) continue;
                    Field field = (Field)hashMap.get(fieldInfo.fieldName);
                    Mapper.ImplicitCollectionMapping implicitCollectionMapping = AbstractReflectionConverter.this.mapper.getImplicitCollectionDefForFieldName(field.getDeclaringClass() == fieldInfo.definedIn ? clazz : fieldInfo.definedIn, fieldInfo.fieldName);
                    if (implicitCollectionMapping != null) {
                        hashSet = (HashSet<Mapper.ImplicitCollectionMapping>)hashMap2.get(fieldInfo.fieldName);
                        if (hashSet == null) {
                            hashSet = new HashSet<Mapper.ImplicitCollectionMapping>();
                            hashSet.add(implicitCollectionMapping);
                            hashMap2.put(fieldInfo.fieldName, hashSet);
                        } else if (!hashSet.add(implicitCollectionMapping)) {
                            implicitCollectionMapping = null;
                        }
                    }
                    if (implicitCollectionMapping != null) {
                        Iterator iterator;
                        if (marshallingContext instanceof ReferencingMarshallingContext && fieldInfo.value != Collections.EMPTY_LIST && fieldInfo.value != Collections.EMPTY_SET && fieldInfo.value != Collections.EMPTY_MAP) {
                            hashSet = (ReferencingMarshallingContext)marshallingContext;
                            hashSet.registerImplicit(fieldInfo.value);
                        }
                        boolean bl2 = fieldInfo.value instanceof Collection;
                        boolean bl3 = fieldInfo.value instanceof Map;
                        boolean bl4 = bl3 && implicitCollectionMapping.getKeyFieldName() == null;
                        boolean bl5 = fieldInfo.value.getClass().isArray();
                        Iterator iterator2 = bl5 ? new ArrayIterator(fieldInfo.value) : (bl2 ? ((Collection)fieldInfo.value).iterator() : (iterator = bl4 ? ((Map)fieldInfo.value).entrySet().iterator() : ((Map)fieldInfo.value).values().iterator()));
                        while (iterator.hasNext()) {
                            String string;
                            Class<?> clazz2;
                            Object e2 = iterator.next();
                            if (e2 == null) {
                                clazz2 = Object.class;
                                string = AbstractReflectionConverter.this.mapper.serializedClass(null);
                            } else {
                                if (bl4) {
                                    String string2 = implicitCollectionMapping.getItemFieldName() != null ? implicitCollectionMapping.getItemFieldName() : AbstractReflectionConverter.this.mapper.serializedClass(Map.Entry.class);
                                    Map.Entry entry = (Map.Entry)e2;
                                    ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, string2, entry.getClass());
                                    this.writeItem(entry.getKey(), marshallingContext, hierarchicalStreamWriter);
                                    this.writeItem(entry.getValue(), marshallingContext, hierarchicalStreamWriter);
                                    hierarchicalStreamWriter.endNode();
                                    continue;
                                }
                                if (implicitCollectionMapping.getItemFieldName() != null) {
                                    clazz2 = implicitCollectionMapping.getItemType();
                                    string = implicitCollectionMapping.getItemFieldName();
                                } else {
                                    clazz2 = e2.getClass();
                                    string = AbstractReflectionConverter.this.mapper.serializedClass(clazz2);
                                }
                            }
                            this.writeField(fieldInfo.fieldName, string, clazz2, fieldInfo.definedIn, e2);
                        }
                        continue;
                    }
                    this.writeField(fieldInfo.fieldName, null, fieldInfo.type, fieldInfo.definedIn, fieldInfo.value);
                }
            }

            void writeField(String string, String string2, Class clazz5, Class clazz2, Object object) {
                Class<?> clazz3 = object != null ? object.getClass() : clazz5;
                ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, string2 != null ? string2 : AbstractReflectionConverter.this.mapper.serializedMember(clazz, string), clazz3);
                if (object != null) {
                    Object object2;
                    Object object3;
                    Class clazz4 = AbstractReflectionConverter.this.mapper.defaultImplementationOf(clazz5);
                    if (!clazz3.equals(clazz4) && !((String)(object3 = AbstractReflectionConverter.this.mapper.serializedClass(clazz3))).equals(AbstractReflectionConverter.this.mapper.serializedClass(clazz4)) && (object2 = AbstractReflectionConverter.this.mapper.aliasForSystemAttribute("class")) != null) {
                        hierarchicalStreamWriter.addAttribute((String)object2, (String)object3);
                    }
                    if (((Field)(object3 = (Field)hashMap.get(string))).getDeclaringClass() != clazz2 && (object2 = AbstractReflectionConverter.this.mapper.aliasForSystemAttribute("defined-in")) != null) {
                        hierarchicalStreamWriter.addAttribute((String)object2, AbstractReflectionConverter.this.mapper.serializedClass(clazz2));
                    }
                    object2 = AbstractReflectionConverter.this.reflectionProvider.getField(clazz2, string);
                    AbstractReflectionConverter.this.marshallField(marshallingContext, object, (Field)object2);
                }
                hierarchicalStreamWriter.endNode();
            }

            void writeItem(Object object, MarshallingContext marshallingContext2, HierarchicalStreamWriter hierarchicalStreamWriter2) {
                if (object == null) {
                    String string = AbstractReflectionConverter.this.mapper.serializedClass(null);
                    ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter2, string, Mapper.Null.class);
                    hierarchicalStreamWriter2.endNode();
                } else {
                    String string = AbstractReflectionConverter.this.mapper.serializedClass(object.getClass());
                    ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter2, string, object.getClass());
                    marshallingContext2.convertAnother(object);
                    hierarchicalStreamWriter2.endNode();
                }
            }
        };
    }

    protected void marshallField(MarshallingContext marshallingContext, Object object, Field field) {
        marshallingContext.convertAnother(object, this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName()));
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Object object = this.instantiateNewInstance(hierarchicalStreamReader, unmarshallingContext);
        object = this.doUnmarshal(object, hierarchicalStreamReader, unmarshallingContext);
        return this.serializationMembers.callReadResolve(object);
    }

    public Object doUnmarshal(Object object, HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Map.Entry<Object, Object> entry;
        Class clazz;
        Object object2;
        Class<Object> clazz2;
        Object object4;
        Object object5;
        Class clazz3 = object.getClass();
        HashSet hashSet = new HashSet(){

            public boolean add(Object object) {
                if (!super.add(object)) {
                    throw new DuplicateFieldException(((FastField)object).getName());
                }
                return true;
            }
        };
        Iterator iterator = hierarchicalStreamReader.getAttributeNames();
        while (iterator.hasNext()) {
            object5 = (String)iterator.next();
            object4 = this.mapper.realMember(clazz3, this.mapper.attributeForAlias((String)object5));
            Field object32 = this.reflectionProvider.getFieldOrNull(clazz3, (String)object4);
            if (object32 == null || !this.shouldUnmarshalField(object32) || !this.mapper.shouldSerializeMember(clazz2 = object32.getDeclaringClass(), (String)object4)) continue;
            object2 = this.mapper.getConverterFromAttribute(clazz2, (String)object4, object32.getType());
            clazz = object32.getType();
            if (object2 == null) continue;
            entry = object2.fromString(hierarchicalStreamReader.getAttribute((String)object5));
            if (clazz.isPrimitive()) {
                clazz = Primitives.box(clazz);
            }
            if (entry != null && !clazz.isAssignableFrom(entry.getClass())) {
                ConversionException conversionException = new ConversionException("Cannot convert type");
                conversionException.add("source-type", entry.getClass().getName());
                conversionException.add("target-type", clazz.getName());
                throw conversionException;
            }
            hashSet.add(new FastField(clazz2, (String)object4));
            this.reflectionProvider.writeField(object, (String)object4, entry, clazz2);
        }
        object5 = null;
        while (hierarchicalStreamReader.hasMoreChildren()) {
            Object object3;
            hierarchicalStreamReader.moveDown();
            object4 = hierarchicalStreamReader.getNodeName();
            Class clazz4 = this.readDeclaringClass(hierarchicalStreamReader);
            clazz2 = clazz4 == null ? clazz3 : clazz4;
            object2 = this.mapper.realMember(clazz2, (String)object4);
            clazz = this.mapper.getImplicitCollectionDefForFieldName(clazz2, (String)object2);
            String string = null;
            Field field = null;
            Object object6 = null;
            if (clazz == null) {
                Object object7;
                Object object8;
                field = this.reflectionProvider.getFieldOrNull(clazz2, (String)object2);
                if (field == null) {
                    object3 = this.mapper.getItemTypeForItemFieldName(clazz2, (String)object2);
                    if (object3 != null) {
                        object8 = HierarchicalStreams.readClassAttribute(hierarchicalStreamReader, this.mapper);
                        object6 = object8 != null ? this.mapper.realClass((String)object8) : object3;
                    } else {
                        try {
                            object6 = this.mapper.realClass((String)object4);
                            string = this.mapper.getFieldNameForItemTypeAndName(clazz2, (Class)object6, (String)object4);
                        }
                        catch (CannotResolveClassException cannotResolveClassException) {
                            // empty catch block
                        }
                        if (object6 == null || object6 != null && string == null) {
                            this.handleUnknownField(clazz4, (String)object2, clazz2, (String)object4);
                            object6 = null;
                        }
                    }
                    if (object6 == null) {
                        entry = null;
                    } else if (Map.Entry.class.equals(object6)) {
                        hierarchicalStreamReader.moveDown();
                        object8 = unmarshallingContext.convertAnother(object, HierarchicalStreams.readClassType(hierarchicalStreamReader, this.mapper));
                        hierarchicalStreamReader.moveUp();
                        hierarchicalStreamReader.moveDown();
                        object7 = unmarshallingContext.convertAnother(object, HierarchicalStreams.readClassType(hierarchicalStreamReader, this.mapper));
                        hierarchicalStreamReader.moveUp();
                        entry = Collections.singletonMap(object8, object7).entrySet().iterator().next();
                    } else {
                        entry = unmarshallingContext.convertAnother(object, (Class)object6);
                    }
                } else {
                    boolean bl2 = false;
                    if (clazz4 == null) {
                        while (field != null && !(bl2 = this.shouldUnmarshalField(field) && this.mapper.shouldSerializeMember(field.getDeclaringClass(), (String)object2))) {
                            field = this.reflectionProvider.getFieldOrNull(field.getDeclaringClass().getSuperclass(), (String)object2);
                        }
                    }
                    if (field != null && (bl2 || this.shouldUnmarshalField(field) && this.mapper.shouldSerializeMember(field.getDeclaringClass(), (String)object2))) {
                        object8 = HierarchicalStreams.readClassAttribute(hierarchicalStreamReader, this.mapper);
                        object6 = object8 != null ? this.mapper.realClass((String)object8) : this.mapper.defaultImplementationOf(field.getType());
                        entry = this.unmarshallField(unmarshallingContext, object, (Class)object6, field);
                        object7 = field.getType();
                        if (!((Class)object7).isPrimitive()) {
                            object6 = object7;
                        }
                    } else {
                        entry = null;
                    }
                }
            } else {
                string = clazz.getFieldName();
                object6 = clazz.getItemType();
                if (object6 == null) {
                    object3 = HierarchicalStreams.readClassAttribute(hierarchicalStreamReader, this.mapper);
                    object6 = this.mapper.realClass((String)(object3 != null ? object3 : object4));
                }
                entry = unmarshallingContext.convertAnother(object, (Class)object6);
            }
            if (entry != null && !((Class)object6).isAssignableFrom(entry.getClass())) {
                throw new ConversionException("Cannot convert type " + entry.getClass().getName() + " to type " + ((Class)object6).getName());
            }
            if (field != null) {
                this.reflectionProvider.writeField(object, (String)object2, entry, field.getDeclaringClass());
                hashSet.add(new FastField(field.getDeclaringClass(), (String)object2));
            } else if (object6 != null) {
                if (string == null) {
                    string = this.mapper.getFieldNameForItemTypeAndName(clazz2, entry != null ? entry.getClass() : Mapper.Null.class, (String)object4);
                }
                if (object5 == null) {
                    object5 = new HashMap();
                }
                this.writeValueToImplicitCollection(entry, (Map)object5, object, new FieldLocation(string, clazz2));
            }
            hierarchicalStreamReader.moveUp();
        }
        if (object5 != null) {
            for (Map.Entry entry2 : object5.entrySet()) {
                clazz2 = entry2.getValue();
                if (!(clazz2 instanceof ArraysList)) continue;
                object2 = ((ArraysList)((Object)clazz2)).toPhysicalArray();
                clazz = (FieldLocation)entry2.getKey();
                entry = this.reflectionProvider.getFieldOrNull(((FieldLocation)((Object)clazz)).definedIn, ((FieldLocation)((Object)clazz)).fieldName);
                this.reflectionProvider.writeField(object, ((FieldLocation)((Object)clazz)).fieldName, object2, entry != null ? ((Field)((Object)entry)).getDeclaringClass() : null);
            }
        }
        return object;
    }

    protected Object unmarshallField(UnmarshallingContext unmarshallingContext, Object object, Class clazz, Field field) {
        return unmarshallingContext.convertAnother(object, clazz, this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName()));
    }

    protected boolean shouldUnmarshalTransientFields() {
        return false;
    }

    protected boolean shouldUnmarshalField(Field field) {
        return !Modifier.isTransient(field.getModifiers()) || this.shouldUnmarshalTransientFields();
    }

    private void handleUnknownField(Class clazz, String string, Class clazz2, String string2) {
        if (clazz == null) {
            for (Class clazz3 = clazz2; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
                if (this.mapper.shouldSerializeMember(clazz3, string2)) continue;
                return;
            }
        }
        throw new UnknownFieldException(clazz2.getName(), string);
    }

    private void writeValueToImplicitCollection(Object object, Map map, Object object2, FieldLocation fieldLocation) {
        Collection collection = (Collection)map.get(fieldLocation);
        if (collection == null) {
            Class clazz;
            Field field = this.reflectionProvider.getFieldOrNull(fieldLocation.definedIn, fieldLocation.fieldName);
            Class clazz2 = clazz = field != null ? field.getType() : this.reflectionProvider.getFieldType(object2, fieldLocation.fieldName, null);
            if (clazz.isArray()) {
                collection = new ArraysList(clazz);
            } else {
                Object object3;
                Class clazz3 = this.mapper.defaultImplementationOf(clazz);
                if (!Collection.class.isAssignableFrom(clazz3) && !Map.class.isAssignableFrom(clazz3)) {
                    ObjectAccessException objectAccessException = new ObjectAccessException("Field is configured for an implicit Collection or Map, but is of an incompatible type");
                    objectAccessException.add("field", object2.getClass().getName() + "." + fieldLocation.fieldName);
                    objectAccessException.add("field-type", clazz3.getName());
                    throw objectAccessException;
                }
                if (this.pureJavaReflectionProvider == null) {
                    this.pureJavaReflectionProvider = new PureJavaReflectionProvider();
                }
                if ((object3 = this.pureJavaReflectionProvider.newInstance(clazz3)) instanceof Collection) {
                    collection = (Collection)object3;
                } else {
                    Mapper.ImplicitCollectionMapping implicitCollectionMapping = this.mapper.getImplicitCollectionDefForFieldName(fieldLocation.definedIn, fieldLocation.fieldName);
                    collection = new MappingList((Map)object3, implicitCollectionMapping.getKeyFieldName());
                }
                this.reflectionProvider.writeField(object2, fieldLocation.fieldName, object3, field != null ? field.getDeclaringClass() : null);
            }
            map.put(fieldLocation, collection);
        }
        collection.add(object);
    }

    private Class readDeclaringClass(HierarchicalStreamReader hierarchicalStreamReader) {
        String string = this.mapper.aliasForSystemAttribute("defined-in");
        String string2 = string == null ? null : hierarchicalStreamReader.getAttribute(string);
        return string2 == null ? null : this.mapper.realClass(string2);
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String string = this.mapper.aliasForSystemAttribute("resolves-to");
        String string2 = string == null ? null : hierarchicalStreamReader.getAttribute(string);
        Object object = unmarshallingContext.currentObject();
        if (object != null) {
            return object;
        }
        if (string2 != null) {
            return this.reflectionProvider.newInstance(this.mapper.realClass(string2));
        }
        return this.reflectionProvider.newInstance(unmarshallingContext.getRequiredType());
    }

    public void flushCache() {
        this.serializationMethodInvoker.flushCache();
    }

    protected Object readResolve() {
        this.serializationMethodInvoker = new SerializationMethodInvoker();
        this.serializationMembers = this.serializationMethodInvoker.serializationMembers;
        return this;
    }

    private class MappingList
    extends AbstractList {
        private final Map map;
        private final String keyFieldName;
        private final Map fieldCache = new HashMap();

        public MappingList(Map map, String string) {
            this.map = map;
            this.keyFieldName = string;
        }

        public boolean add(Object object) {
            Object object2;
            if (object == null) {
                boolean bl2 = !this.map.containsKey(null);
                this.map.put(null, null);
                return bl2;
            }
            Class<?> clazz = object.getClass();
            if (this.keyFieldName != null) {
                object2 = (Field)this.fieldCache.get(clazz);
                if (object2 == null) {
                    object2 = AbstractReflectionConverter.this.reflectionProvider.getField(clazz, this.keyFieldName);
                    this.fieldCache.put(clazz, object2);
                }
                if (object2 != null) {
                    Object object3 = Fields.read((Field)object2, object);
                    return this.map.put(object3, object) == null;
                }
            } else if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.map.put(entry.getKey(), entry.getValue()) == null;
            }
            object2 = new ConversionException("Element  is not defined as entry for implicit map");
            ((ErrorWritingException)object2).add("map-type", this.map.getClass().getName());
            ((ErrorWritingException)object2).add("element-type", object.getClass().getName());
            throw object2;
        }

        public Object get(int n2) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class ArraysList
    extends ArrayList {
        final Class physicalFieldType;

        ArraysList(Class clazz) {
            this.physicalFieldType = clazz;
        }

        Object toPhysicalArray() {
            Object[] objectArray = this.toArray();
            Object object = Array.newInstance(this.physicalFieldType.getComponentType(), objectArray.length);
            if (this.physicalFieldType.getComponentType().isPrimitive()) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    Array.set(object, i2, Array.get(objectArray, i2));
                }
            } else {
                System.arraycopy(objectArray, 0, object, 0, objectArray.length);
            }
            return object;
        }
    }

    private static class FieldInfo
    extends FieldLocation {
        final Class type;
        final Object value;

        FieldInfo(String string, Class clazz, Class clazz2, Object object) {
            super(string, clazz2);
            this.type = clazz;
            this.value = object;
        }
    }

    private static class FieldLocation {
        final String fieldName;
        final Class definedIn;

        FieldLocation(String string, Class clazz) {
            this.fieldName = string;
            this.definedIn = clazz;
        }

        public int hashCode() {
            int n2 = 7;
            int n3 = 1;
            n3 = 7 * n3 + (this.definedIn == null ? 0 : this.definedIn.getName().hashCode());
            n3 = 7 * n3 + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FieldLocation fieldLocation = (FieldLocation)object;
            if (this.definedIn != fieldLocation.definedIn) {
                return false;
            }
            return !(this.fieldName == null ? fieldLocation.fieldName != null : !this.fieldName.equals(fieldLocation.fieldName));
        }
    }

    public static class UnknownFieldException
    extends ConversionException {
        public UnknownFieldException(String string, String string2) {
            super("No such field " + string + "." + string2);
            this.add("field", string2);
        }
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String string) {
            super("Duplicate field " + string);
            this.add("field", string);
        }
    }
}

