/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.NoOp;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.ErrorWritingException;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProviderWrapper;
import zz.com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.CGLIBMapper;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class CGLIBEnhancedConverter
extends SerializableConverter {
    private static String DEFAULT_NAMING_MARKER = "$$EnhancerByCGLIB$$";
    private static String CALLBACK_MARKER = "CGLIB$CALLBACK_";
    private transient Map fieldCache = new HashMap();

    public CGLIBEnhancedConverter(Mapper mapper, ReflectionProvider reflectionProvider, ClassLoaderReference classLoaderReference) {
        super(mapper, (ReflectionProvider)new CGLIBFilteringReflectionProvider(reflectionProvider), classLoaderReference);
    }

    public CGLIBEnhancedConverter(Mapper mapper, ReflectionProvider reflectionProvider, ClassLoader classLoader) {
        super(mapper, (ReflectionProvider)new CGLIBFilteringReflectionProvider(reflectionProvider), classLoader);
    }

    public CGLIBEnhancedConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this(mapper, (ReflectionProvider)new CGLIBFilteringReflectionProvider(reflectionProvider), CGLIBEnhancedConverter.class.getClassLoader());
    }

    public boolean canConvert(Class clazz) {
        return Enhancer.isEnhanced((Class)clazz) && clazz.getName().indexOf(DEFAULT_NAMING_MARKER) > 0 || clazz == CGLIBMapper.Marker.class;
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Object object2;
        Callback[] callbackArray;
        Class<?> clazz = object.getClass();
        boolean bl2 = Factory.class.isAssignableFrom(clazz);
        ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, "type", clazz);
        marshallingContext.convertAnother(clazz.getSuperclass());
        hierarchicalStreamWriter.endNode();
        hierarchicalStreamWriter.startNode("interfaces");
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2] == Factory.class) continue;
            ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, this.mapper.serializedClass(classArray[i2].getClass()), classArray[i2].getClass());
            marshallingContext.convertAnother(classArray[i2]);
            hierarchicalStreamWriter.endNode();
        }
        hierarchicalStreamWriter.endNode();
        hierarchicalStreamWriter.startNode("hasFactory");
        hierarchicalStreamWriter.setValue(String.valueOf(bl2));
        hierarchicalStreamWriter.endNode();
        Map map = null;
        Callback[] callbackArray2 = callbackArray = bl2 ? ((Factory)object).getCallbacks() : this.getCallbacks(object);
        if (callbackArray.length > 1) {
            if (!bl2) {
                ConversionException conversionException = new ConversionException("Cannot handle CGLIB enhanced proxies without factory that have multiple callbacks");
                conversionException.add("proxy-superclass", clazz.getSuperclass().getName());
                conversionException.add("number-of-callbacks", String.valueOf(callbackArray.length));
                throw conversionException;
            }
            map = this.createCallbackIndexMap((Factory)object);
            hierarchicalStreamWriter.startNode("callbacks");
            hierarchicalStreamWriter.startNode("mapping");
            marshallingContext.convertAnother(map);
            hierarchicalStreamWriter.endNode();
        }
        boolean bl3 = false;
        for (int i3 = 0; i3 < callbackArray.length; ++i3) {
            object2 = callbackArray[i3];
            if (object2 == null) {
                String string = this.mapper.serializedClass(null);
                hierarchicalStreamWriter.startNode(string);
                hierarchicalStreamWriter.endNode();
                continue;
            }
            bl3 = bl3 || MethodInterceptor.class.isAssignableFrom(object2.getClass());
            ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, this.mapper.serializedClass(object2.getClass()), object2.getClass());
            marshallingContext.convertAnother(object2);
            hierarchicalStreamWriter.endNode();
        }
        if (callbackArray.length > 1) {
            hierarchicalStreamWriter.endNode();
        }
        try {
            Field field = clazz.getDeclaredField("serialVersionUID");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            long l2 = field.getLong(null);
            ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, "serialVersionUID", String.class);
            hierarchicalStreamWriter.setValue(String.valueOf(l2));
            hierarchicalStreamWriter.endNode();
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            object2 = new ObjectAccessException("Cannot access field", illegalAccessException);
            ((ErrorWritingException)object2).add("field", clazz.getName() + ".serialVersionUID");
            throw object2;
        }
        if (bl3) {
            hierarchicalStreamWriter.startNode("instance");
            super.doMarshalConditionally(object, hierarchicalStreamWriter, marshallingContext);
            hierarchicalStreamWriter.endNode();
        }
    }

    private Callback[] getCallbacks(Object object) {
        Class<?> clazz = object.getClass();
        ArrayList<Field> arrayList = (ArrayList<Field>)this.fieldCache.get(clazz.getName());
        if (arrayList == null) {
            arrayList = new ArrayList<Field>();
            this.fieldCache.put(clazz.getName(), arrayList);
            int n2 = 0;
            while (true) {
                try {
                    Field field = clazz.getDeclaredField(CALLBACK_MARKER + n2);
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    arrayList.add(field);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    break;
                }
                ++n2;
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Object object2;
            try {
                Field field = (Field)arrayList.get(i2);
                object2 = field.get(object);
                arrayList2.add(object2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                object2 = new ObjectAccessException("Cannot access field", illegalAccessException);
                ((ErrorWritingException)object2).add("field", clazz.getName() + "." + CALLBACK_MARKER + i2);
                throw object2;
            }
        }
        return arrayList2.toArray(new Callback[arrayList2.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Map createCallbackIndexMap(Factory factory) {
        Object object;
        Callback[] callbackArray = factory.getCallbacks();
        Callback[] callbackArray2 = new Callback[callbackArray.length];
        HashMap hashMap = new HashMap();
        int n2 = -1;
        for (int i2 = 0; i2 < callbackArray.length; ++i2) {
            object = callbackArray[i2];
            if (object == null) {
                callbackArray2[i2] = null;
                continue;
            }
            if (NoOp.class.isAssignableFrom(object.getClass())) {
                callbackArray2[i2] = NoOp.INSTANCE;
                n2 = i2;
                continue;
            }
            callbackArray2[i2] = this.createReverseEngineeredCallbackOfProperType((Callback)object, i2, hashMap);
        }
        try {
            Object object2;
            Object object3;
            void var8_10;
            Class clazz;
            factory.setCallbacks(callbackArray2);
            HashSet hashSet = new HashSet();
            object = new HashSet();
            Class<?> clazz2 = factory.getClass();
            do {
                object.addAll(Arrays.asList(var8_10.getDeclaredMethods()));
                object.addAll(Arrays.asList(var8_10.getMethods()));
                object3 = var8_10.getInterfaces();
                hashSet.addAll(Arrays.asList(object3));
            } while ((clazz = var8_10.getSuperclass()) != null);
            for (Class clazz3 : hashSet) {
                object.addAll(Arrays.asList(clazz3.getDeclaredMethods()));
            }
            object3 = object.iterator();
            while (object3.hasNext()) {
                object2 = (Method)object3.next();
                if (!((AccessibleObject)object2).isAccessible()) {
                    ((Method)object2).setAccessible(true);
                }
                if (Factory.class.isAssignableFrom(((Method)object2).getDeclaringClass()) || (((Method)object2).getModifiers() & 0x18) > 0) {
                    object3.remove();
                    continue;
                }
                Class[] classArray = ((Method)object2).getParameterTypes();
                Object object4 = object2;
                try {
                    if ((((Method)object2).getModifiers() & 0x400) > 0) {
                        object4 = factory.getClass().getMethod(((Method)object2).getName(), ((Method)object2).getParameterTypes());
                    }
                    hashMap.put(null, object2);
                    ((Method)object4).invoke((Object)factory, classArray == null ? (Object[])null : this.createNullArguments(classArray));
                }
                catch (IllegalAccessException illegalAccessException) {
                    ObjectAccessException objectAccessException = new ObjectAccessException("Cannot access method", illegalAccessException);
                    objectAccessException.add("method", ((Method)object4).toString());
                    throw objectAccessException;
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    void var8_12;
                    ConversionException conversionException = new ConversionException("CGLIB enhanced proxies wit abstract nethod that has not been implemented");
                    conversionException.add("proxy-superclass", var8_12.getSuperclass().getName());
                    conversionException.add("method", ((Method)object2).toString());
                    throw conversionException;
                }
                if (!hashMap.containsKey(object2)) continue;
                object3.remove();
            }
            if (n2 >= 0) {
                object3 = new Integer(n2);
                object2 = object.iterator();
                while (object2.hasNext()) {
                    hashMap.put(object2.next(), object3);
                }
            }
        }
        finally {
            factory.setCallbacks(callbackArray);
        }
        hashMap.remove(null);
        return hashMap;
    }

    private Object[] createNullArguments(Class[] classArray) {
        Object[] objectArray = new Object[classArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Class clazz = classArray[i2];
            if (!clazz.isPrimitive()) continue;
            objectArray[i2] = clazz == Byte.TYPE ? new Byte(0) : (clazz == Short.TYPE ? new Short(0) : (clazz == Integer.TYPE ? new Integer(0) : (clazz == Long.TYPE ? new Long(0L) : (clazz == Float.TYPE ? new Float(0.0f) : (clazz == Double.TYPE ? new Double(0.0) : (clazz == Character.TYPE ? (Comparable<Character>)new Character('\u0000') : (Comparable<Character>)Boolean.FALSE))))));
        }
        return objectArray;
    }

    private Callback createReverseEngineeredCallbackOfProperType(Callback callback, int n2, Map map) {
        Class<?> clazz = null;
        Class<?>[] classArray = callback.getClass().getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (!Callback.class.isAssignableFrom(classArray[i2])) continue;
            clazz = classArray[i2];
            if (clazz == Callback.class) {
                ConversionException conversionException = new ConversionException("Cannot handle CGLIB callback");
                conversionException.add("CGLIB-callback-type", callback.getClass().getName());
                throw conversionException;
            }
            classArray = clazz.getInterfaces();
            if (Arrays.asList(classArray).contains(Callback.class)) break;
            i2 = -1;
        }
        return (Callback)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ReverseEngineeringInvocationHandler(n2, map));
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Enhancer enhancer = new Enhancer();
        hierarchicalStreamReader.moveDown();
        enhancer.setSuperclass((Class)unmarshallingContext.convertAnother(null, Class.class));
        hierarchicalStreamReader.moveUp();
        hierarchicalStreamReader.moveDown();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            arrayList.add(unmarshallingContext.convertAnother(null, this.mapper.realClass(hierarchicalStreamReader.getNodeName())));
            hierarchicalStreamReader.moveUp();
        }
        enhancer.setInterfaces(arrayList.toArray(new Class[arrayList.size()]));
        hierarchicalStreamReader.moveUp();
        hierarchicalStreamReader.moveDown();
        boolean bl2 = Boolean.valueOf(hierarchicalStreamReader.getValue());
        enhancer.setUseFactory(bl2);
        hierarchicalStreamReader.moveUp();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        Map map = null;
        hierarchicalStreamReader.moveDown();
        if ("callbacks".equals(hierarchicalStreamReader.getNodeName())) {
            hierarchicalStreamReader.moveDown();
            map = (Map)unmarshallingContext.convertAnother(null, HashMap.class);
            hierarchicalStreamReader.moveUp();
            while (hierarchicalStreamReader.hasMoreChildren()) {
                hierarchicalStreamReader.moveDown();
                this.readCallback(hierarchicalStreamReader, unmarshallingContext, arrayList2, arrayList3);
                hierarchicalStreamReader.moveUp();
            }
        } else {
            this.readCallback(hierarchicalStreamReader, unmarshallingContext, arrayList2, arrayList3);
        }
        enhancer.setCallbacks(arrayList2.toArray(new Callback[arrayList2.size()]));
        if (map != null) {
            enhancer.setCallbackFilter((CallbackFilter)new ReverseEngineeredCallbackFilter(map));
        }
        hierarchicalStreamReader.moveUp();
        Object object = null;
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            if (hierarchicalStreamReader.getNodeName().equals("serialVersionUID")) {
                enhancer.setSerialVersionUID(Long.valueOf(hierarchicalStreamReader.getValue()));
            } else if (hierarchicalStreamReader.getNodeName().equals("instance")) {
                object = this.create(enhancer, arrayList3, bl2);
                super.doUnmarshalConditionally(object, hierarchicalStreamReader, unmarshallingContext);
            }
            hierarchicalStreamReader.moveUp();
        }
        if (object == null) {
            object = this.create(enhancer, arrayList3, bl2);
        }
        return this.serializationMembers.callReadResolve(object);
    }

    private void readCallback(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, List list, List list2) {
        Callback callback = (Callback)unmarshallingContext.convertAnother(null, this.mapper.realClass(hierarchicalStreamReader.getNodeName()));
        list2.add(callback);
        if (callback == null) {
            list.add(NoOp.INSTANCE);
        } else {
            list.add(callback);
        }
    }

    private Object create(Enhancer enhancer, List list, boolean bl2) {
        Object object = enhancer.create();
        if (bl2) {
            ((Factory)object).setCallbacks(list.toArray(new Callback[list.size()]));
        }
        return object;
    }

    protected List hierarchyFor(Class clazz) {
        List list = super.hierarchyFor(clazz);
        list.remove(list.size() - 1);
        return list;
    }

    protected Object readResolve() {
        super.readResolve();
        this.fieldCache = new HashMap();
        return this;
    }

    private static class ReverseEngineeredCallbackFilter
    implements CallbackFilter {
        private final Map callbackIndexMap;

        public ReverseEngineeredCallbackFilter(Map map) {
            this.callbackIndexMap = map;
        }

        public int accept(Method method) {
            if (!this.callbackIndexMap.containsKey(method)) {
                ConversionException conversionException = new ConversionException("CGLIB callback not detected in reverse engineering");
                conversionException.add("CGLIB-callback", method.toString());
                throw conversionException;
            }
            return (Integer)this.callbackIndexMap.get(method);
        }
    }

    private static final class ReverseEngineeringInvocationHandler
    implements InvocationHandler {
        private final Integer index;
        private final Map indexMap;

        public ReverseEngineeringInvocationHandler(int n2, Map map) {
            this.indexMap = map;
            this.index = new Integer(n2);
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            this.indexMap.put(this.indexMap.get(null), this.index);
            return null;
        }
    }

    private static class CGLIBFilteringReflectionProvider
    extends ReflectionProviderWrapper {
        public CGLIBFilteringReflectionProvider(ReflectionProvider reflectionProvider) {
            super(reflectionProvider);
        }

        public void visitSerializableFields(Object object, final ReflectionProvider.Visitor visitor) {
            this.wrapped.visitSerializableFields(object, new ReflectionProvider.Visitor(){

                public void visit(String string, Class clazz, Class clazz2, Object object) {
                    if (!string.startsWith("CGLIB$")) {
                        visitor.visit(string, clazz, clazz2, object);
                    }
                }
            });
        }
    }
}

