/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.reflection;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputValidation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.DataHolder;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.ReferencingMarshallingContext;
import zz.com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import zz.com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import zz.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import zz.com.thoughtworks.xstream.core.util.SerializationMembers;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class ExternalizableConverter
implements Converter {
    private Mapper mapper;
    private final ClassLoaderReference classLoaderReference;
    private transient SerializationMembers serializationMembers;

    public ExternalizableConverter(Mapper mapper, ClassLoaderReference classLoaderReference) {
        this.mapper = mapper;
        this.classLoaderReference = classLoaderReference;
        this.serializationMembers = new SerializationMembers();
    }

    public ExternalizableConverter(Mapper mapper, ClassLoader classLoader) {
        this(mapper, new ClassLoaderReference(classLoader));
    }

    public ExternalizableConverter(Mapper mapper) {
        this(mapper, ExternalizableConverter.class.getClassLoader());
    }

    public boolean canConvert(Class clazz) {
        return JVM.canCreateDerivedObjectOutputStream() && Externalizable.class.isAssignableFrom(clazz);
    }

    public void marshal(Object object, final HierarchicalStreamWriter hierarchicalStreamWriter, final MarshallingContext marshallingContext) {
        Object object2 = this.serializationMembers.callWriteReplace(object);
        if (object2 != object && marshallingContext instanceof ReferencingMarshallingContext) {
            ((ReferencingMarshallingContext)marshallingContext).replace(object, object2);
        }
        if (object2.getClass() != object.getClass()) {
            String string = this.mapper.aliasForSystemAttribute("resolves-to");
            if (string != null) {
                hierarchicalStreamWriter.addAttribute(string, this.mapper.serializedClass(object2.getClass()));
            }
            marshallingContext.convertAnother(object2);
        } else {
            try {
                Externalizable externalizable = (Externalizable)object2;
                CustomObjectOutputStream.StreamCallback streamCallback = new CustomObjectOutputStream.StreamCallback(){

                    public void writeToStream(Object object) {
                        if (object == null) {
                            hierarchicalStreamWriter.startNode("null");
                            hierarchicalStreamWriter.endNode();
                        } else {
                            ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, ExternalizableConverter.this.mapper.serializedClass(object.getClass()), object.getClass());
                            marshallingContext.convertAnother(object);
                            hierarchicalStreamWriter.endNode();
                        }
                    }

                    public void writeFieldsToStream(Map map) {
                        throw new UnsupportedOperationException();
                    }

                    public void defaultWriteObject() {
                        throw new UnsupportedOperationException();
                    }

                    public void flush() {
                        hierarchicalStreamWriter.flush();
                    }

                    public void close() {
                        throw new UnsupportedOperationException("Objects are not allowed to call ObjectOutput.close() from writeExternal()");
                    }
                };
                CustomObjectOutputStream customObjectOutputStream = CustomObjectOutputStream.getInstance(marshallingContext, streamCallback);
                externalizable.writeExternal(customObjectOutputStream);
                customObjectOutputStream.popCallback();
            }
            catch (IOException iOException) {
                throw new StreamException("Cannot serialize " + object2.getClass().getName() + " using Externalization", iOException);
            }
        }
    }

    public Object unmarshal(final HierarchicalStreamReader hierarchicalStreamReader, final UnmarshallingContext unmarshallingContext) {
        Class clazz = unmarshallingContext.getRequiredType();
        try {
            Constructor constructor = clazz.getDeclaredConstructor(null);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            final Externalizable externalizable = (Externalizable)constructor.newInstance(null);
            CustomObjectInputStream.StreamCallback streamCallback = new CustomObjectInputStream.StreamCallback(){

                public Object readFromStream() {
                    hierarchicalStreamReader.moveDown();
                    Class clazz = HierarchicalStreams.readClassType(hierarchicalStreamReader, ExternalizableConverter.this.mapper);
                    Object object = unmarshallingContext.convertAnother(externalizable, clazz);
                    hierarchicalStreamReader.moveUp();
                    return object;
                }

                public Map readFieldsFromStream() {
                    throw new UnsupportedOperationException();
                }

                public void defaultReadObject() {
                    throw new UnsupportedOperationException();
                }

                public void registerValidation(ObjectInputValidation objectInputValidation, int n2) throws NotActiveException {
                    throw new NotActiveException("stream inactive");
                }

                public void close() {
                    throw new UnsupportedOperationException("Objects are not allowed to call ObjectInput.close() from readExternal()");
                }
            };
            CustomObjectInputStream customObjectInputStream = CustomObjectInputStream.getInstance((DataHolder)unmarshallingContext, streamCallback, this.classLoaderReference);
            externalizable.readExternal(customObjectInputStream);
            customObjectInputStream.popCallback();
            return this.serializationMembers.callReadResolve(externalizable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ConversionException("Missing default constructor of type", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConversionException("Cannot construct type", invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new ConversionException("Cannot construct type", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectAccessException("Cannot construct type", illegalAccessException);
        }
        catch (IOException iOException) {
            throw new StreamException("Cannot externalize " + clazz.getClass(), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConversionException("Cannot construct type", classNotFoundException);
        }
    }

    private Object readResolve() {
        this.serializationMembers = new SerializationMembers();
        return this;
    }
}

