/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.reflection;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.reflection.FieldKey;
import zz.com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import zz.com.thoughtworks.xstream.converters.reflection.ImmutableFieldKeySorter;
import zz.com.thoughtworks.xstream.converters.reflection.MissingFieldException;
import zz.com.thoughtworks.xstream.core.Caching;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.util.OrderRetainingMap;

public class FieldDictionary
implements Caching {
    private static final DictionaryEntry OBJECT_DICTIONARY_ENTRY = new DictionaryEntry(Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    private transient Map dictionaryEntries;
    private final FieldKeySorter sorter;

    public FieldDictionary() {
        this(new ImmutableFieldKeySorter());
    }

    public FieldDictionary(FieldKeySorter fieldKeySorter) {
        this.sorter = fieldKeySorter;
        this.init();
    }

    private void init() {
        this.dictionaryEntries = new HashMap();
    }

    public Iterator serializableFieldsFor(Class clazz) {
        return this.fieldsFor(clazz);
    }

    public Iterator fieldsFor(Class clazz) {
        return this.buildMap(clazz, true).values().iterator();
    }

    public Field field(Class clazz, String string, Class clazz2) {
        Field field = this.fieldOrNull(clazz, string, clazz2);
        if (field == null) {
            throw new MissingFieldException(clazz.getName(), string);
        }
        return field;
    }

    public Field fieldOrNull(Class clazz, String string, Class clazz2) {
        Map map = this.buildMap(clazz, clazz2 != null);
        Field field = (Field)map.get(clazz2 != null ? new FieldKey(string, clazz2, -1) : string);
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildMap(Class clazz, boolean bl2) {
        Class clazz22 = clazz;
        DictionaryEntry dictionaryEntry = null;
        LinkedList linkedList = new LinkedList();
        while (dictionaryEntry == null) {
            dictionaryEntry = Object.class.equals((Object)clazz22) || clazz22 == null ? OBJECT_DICTIONARY_ENTRY : this.getDictionaryEntry(clazz22);
            if (dictionaryEntry != null) continue;
            linkedList.addFirst(clazz22);
            clazz22 = clazz22.getSuperclass();
        }
        for (Class clazz22 : linkedList) {
            DictionaryEntry dictionaryEntry2 = this.buildDictionaryEntryForClass(clazz22, dictionaryEntry);
            FieldDictionary fieldDictionary = this;
            synchronized (fieldDictionary) {
                DictionaryEntry dictionaryEntry3 = this.getDictionaryEntry(clazz22);
                if (dictionaryEntry3 == null) {
                    this.dictionaryEntries.put(clazz22, dictionaryEntry2);
                } else {
                    dictionaryEntry2 = dictionaryEntry3;
                }
            }
            dictionaryEntry = dictionaryEntry2;
        }
        return bl2 ? dictionaryEntry.getKeyedByFieldKey() : dictionaryEntry.getKeyedByFieldName();
    }

    private DictionaryEntry buildDictionaryEntryForClass(Class clazz, DictionaryEntry dictionaryEntry) {
        Object object;
        int n2;
        HashMap<String, Field> hashMap = new HashMap<String, Field>(dictionaryEntry.getKeyedByFieldName());
        OrderRetainingMap orderRetainingMap = new OrderRetainingMap(dictionaryEntry.getKeyedByFieldKey());
        Field[] fieldArray = clazz.getDeclaredFields();
        if (JVM.reverseFieldDefinition()) {
            n2 = fieldArray.length >> 1;
            while (n2-- > 0) {
                int n3 = fieldArray.length - n2 - 1;
                object = fieldArray[n2];
                fieldArray[n2] = fieldArray[n3];
                fieldArray[n3] = object;
            }
        }
        for (n2 = 0; n2 < fieldArray.length; ++n2) {
            Field field = fieldArray[n2];
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            object = new FieldKey(field.getName(), field.getDeclaringClass(), n2);
            Field field2 = (Field)hashMap.get(field.getName());
            if (field2 == null || (field2.getModifiers() & 8) != 0 || field2 != null && (field.getModifiers() & 8) == 0) {
                hashMap.put(field.getName(), field);
            }
            orderRetainingMap.put(object, field);
        }
        Map map = this.sorter.sort(clazz, orderRetainingMap);
        return new DictionaryEntry(hashMap, map);
    }

    private synchronized DictionaryEntry getDictionaryEntry(Class clazz) {
        return (DictionaryEntry)this.dictionaryEntries.get(clazz);
    }

    public synchronized void flushCache() {
        this.dictionaryEntries.clear();
        if (this.sorter instanceof Caching) {
            ((Caching)((Object)this.sorter)).flushCache();
        }
    }

    protected Object readResolve() {
        this.init();
        return this;
    }

    private static final class DictionaryEntry {
        private final Map keyedByFieldName;
        private final Map keyedByFieldKey;

        public DictionaryEntry(Map map, Map map2) {
            this.keyedByFieldName = map;
            this.keyedByFieldKey = map2;
        }

        public Map getKeyedByFieldName() {
            return this.keyedByFieldName;
        }

        public Map getKeyedByFieldKey() {
            return this.keyedByFieldKey;
        }
    }
}

