/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.reflection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import zz.com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import zz.com.thoughtworks.xstream.converters.reflection.ImmutableFieldKeySorter;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.util.Fields;

public class PureJavaReflectionProvider
implements ReflectionProvider {
    private transient Map serializedDataCache;
    protected FieldDictionary fieldDictionary;

    public PureJavaReflectionProvider() {
        this(new FieldDictionary(new ImmutableFieldKeySorter()));
    }

    public PureJavaReflectionProvider(FieldDictionary fieldDictionary) {
        this.fieldDictionary = fieldDictionary;
        this.init();
    }

    public Object newInstance(Class clazz) {
        ObjectAccessException objectAccessException = null;
        try {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            for (int i2 = 0; i2 < constructorArray.length; ++i2) {
                Constructor<?> constructor = constructorArray[i2];
                if (constructor.getParameterTypes().length != 0) continue;
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return constructor.newInstance(new Object[0]);
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                return this.instantiateUsingSerialization(clazz);
            }
            objectAccessException = new ObjectAccessException("Cannot construct type as it does not have a no-args constructor");
        }
        catch (InstantiationException instantiationException) {
            objectAccessException = new ObjectAccessException("Cannot construct type", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            objectAccessException = new ObjectAccessException("Cannot construct type", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            objectAccessException = new ObjectAccessException("Constructor for type threw an exception", invocationTargetException.getTargetException());
        }
        objectAccessException.add("construction-type", clazz.getName());
        throw objectAccessException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateUsingSerialization(final Class clazz) {
        ObjectAccessException objectAccessException = null;
        try {
            Map map = this.serializedDataCache;
            synchronized (map) {
                Closeable closeable;
                byte[] byArray = (byte[])this.serializedDataCache.get(clazz);
                if (byArray == null) {
                    closeable = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)closeable);
                    dataOutputStream.writeShort(-21267);
                    dataOutputStream.writeShort(5);
                    dataOutputStream.writeByte(115);
                    dataOutputStream.writeByte(114);
                    dataOutputStream.writeUTF(clazz.getName());
                    dataOutputStream.writeLong(ObjectStreamClass.lookup(clazz).getSerialVersionUID());
                    dataOutputStream.writeByte(2);
                    dataOutputStream.writeShort(0);
                    dataOutputStream.writeByte(120);
                    dataOutputStream.writeByte(112);
                    byArray = ((ByteArrayOutputStream)closeable).toByteArray();
                    this.serializedDataCache.put(clazz, byArray);
                }
                closeable = new ObjectInputStream(new ByteArrayInputStream(byArray)){

                    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                        return Class.forName(objectStreamClass.getName(), false, clazz.getClassLoader());
                    }
                };
                return ((ObjectInputStream)closeable).readObject();
            }
        }
        catch (IOException iOException) {
            objectAccessException = new ObjectAccessException("Cannot create type by JDK serialization", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            objectAccessException = new ObjectAccessException("Cannot find class", classNotFoundException);
        }
        objectAccessException.add("construction-type", clazz.getName());
        throw objectAccessException;
    }

    public void visitSerializableFields(Object object, ReflectionProvider.Visitor visitor) {
        Iterator iterator = this.fieldDictionary.fieldsFor(object.getClass());
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!this.fieldModifiersSupported(field)) continue;
            this.validateFieldAccess(field);
            Object object2 = Fields.read(field, object);
            visitor.visit(field.getName(), field.getType(), field.getDeclaringClass(), object2);
        }
    }

    public void writeField(Object object, String string, Object object2, Class clazz) {
        Field field = this.fieldDictionary.field(object.getClass(), string, clazz);
        this.validateFieldAccess(field);
        Fields.write(field, object, object2);
    }

    public Class getFieldType(Object object, String string, Class clazz) {
        return this.fieldDictionary.field(object.getClass(), string, clazz).getType();
    }

    public boolean fieldDefinedInClass(String string, Class clazz) {
        Field field = this.fieldDictionary.fieldOrNull(clazz, string, null);
        return field != null && this.fieldModifiersSupported(field);
    }

    protected boolean fieldModifiersSupported(Field field) {
        int n2 = field.getModifiers();
        return !Modifier.isStatic(n2) && !Modifier.isTransient(n2);
    }

    protected void validateFieldAccess(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            if (JVM.is15()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
            } else {
                throw new ObjectAccessException("Invalid final field " + field.getDeclaringClass().getName() + "." + field.getName());
            }
        }
    }

    public Field getField(Class clazz, String string) {
        return this.fieldDictionary.field(clazz, string, null);
    }

    public Field getFieldOrNull(Class clazz, String string) {
        return this.fieldDictionary.fieldOrNull(clazz, string, null);
    }

    public void setFieldDictionary(FieldDictionary fieldDictionary) {
        this.fieldDictionary = fieldDictionary;
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    protected void init() {
        this.serializedDataCache = new WeakHashMap();
    }
}

