/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.reflection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.DataHolder;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import zz.com.thoughtworks.xstream.converters.reflection.MissingFieldException;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProviderWrapper;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import zz.com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import zz.com.thoughtworks.xstream.core.util.Fields;
import zz.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class SerializableConverter
extends AbstractReflectionConverter {
    private static final String ELEMENT_NULL = "null";
    private static final String ELEMENT_DEFAULT = "default";
    private static final String ELEMENT_UNSERIALIZABLE_PARENTS = "unserializable-parents";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_SERIALIZATION = "serialization";
    private static final String ATTRIBUTE_VALUE_CUSTOM = "custom";
    private static final String ELEMENT_FIELDS = "fields";
    private static final String ELEMENT_FIELD = "field";
    private static final String ATTRIBUTE_NAME = "name";
    private final ClassLoaderReference classLoaderReference;

    public SerializableConverter(Mapper mapper, ReflectionProvider reflectionProvider, ClassLoaderReference classLoaderReference) {
        super(mapper, new UnserializableParentsReflectionProvider(reflectionProvider));
        this.classLoaderReference = classLoaderReference;
    }

    public SerializableConverter(Mapper mapper, ReflectionProvider reflectionProvider, ClassLoader classLoader) {
        this(mapper, reflectionProvider, new ClassLoaderReference(classLoader));
    }

    public SerializableConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this(mapper, (ReflectionProvider)new UnserializableParentsReflectionProvider(reflectionProvider), new ClassLoaderReference(null));
    }

    public boolean canConvert(Class clazz) {
        return JVM.canCreateDerivedObjectOutputStream() && this.isSerializable(clazz);
    }

    private boolean isSerializable(Class clazz) {
        if (clazz != null && Serializable.class.isAssignableFrom(clazz) && !clazz.isInterface() && (this.serializationMembers.supportsReadObject(clazz, true) || this.serializationMembers.supportsWriteObject(clazz, true))) {
            Iterator iterator = this.hierarchyFor(clazz).iterator();
            while (iterator.hasNext()) {
                if (Serializable.class.isAssignableFrom((Class)iterator.next())) continue;
                return this.canAccess(clazz);
            }
            return true;
        }
        return false;
    }

    public void doMarshal(final Object object, final HierarchicalStreamWriter hierarchicalStreamWriter, final MarshallingContext marshallingContext) {
        String string = this.mapper.aliasForSystemAttribute(ATTRIBUTE_SERIALIZATION);
        if (string != null) {
            hierarchicalStreamWriter.addAttribute(string, ATTRIBUTE_VALUE_CUSTOM);
        }
        final Class[] classArray = new Class[1];
        final boolean[] blArray = new boolean[]{false};
        CustomObjectOutputStream.StreamCallback streamCallback = new CustomObjectOutputStream.StreamCallback(){

            public void writeToStream(Object object2) {
                if (object2 == null) {
                    hierarchicalStreamWriter.startNode(SerializableConverter.ELEMENT_NULL);
                    hierarchicalStreamWriter.endNode();
                } else {
                    ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, SerializableConverter.this.mapper.serializedClass(object2.getClass()), object2.getClass());
                    marshallingContext.convertAnother(object2);
                    hierarchicalStreamWriter.endNode();
                }
            }

            public void writeFieldsToStream(Map map) {
                ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(classArray[0]);
                hierarchicalStreamWriter.startNode(SerializableConverter.ELEMENT_DEFAULT);
                for (String string : map.keySet()) {
                    String string2;
                    if (!SerializableConverter.this.mapper.shouldSerializeMember(classArray[0], string)) continue;
                    ObjectStreamField objectStreamField = objectStreamClass.getField(string);
                    Object v2 = map.get(string);
                    if (objectStreamField == null) {
                        throw new MissingFieldException(v2.getClass().getName(), string);
                    }
                    if (v2 == null) continue;
                    ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, SerializableConverter.this.mapper.serializedMember(object.getClass(), string), v2.getClass());
                    if (objectStreamField.getType() != v2.getClass() && !objectStreamField.getType().isPrimitive() && (string2 = SerializableConverter.this.mapper.aliasForSystemAttribute(SerializableConverter.ATTRIBUTE_CLASS)) != null) {
                        hierarchicalStreamWriter.addAttribute(string2, SerializableConverter.this.mapper.serializedClass(v2.getClass()));
                    }
                    marshallingContext.convertAnother(v2);
                    hierarchicalStreamWriter.endNode();
                }
                hierarchicalStreamWriter.endNode();
            }

            public void defaultWriteObject() {
                boolean bl2 = false;
                ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(classArray[0]);
                if (objectStreamClass == null) {
                    return;
                }
                ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
                for (int i2 = 0; i2 < objectStreamFieldArray.length; ++i2) {
                    String string;
                    ObjectStreamField objectStreamField = objectStreamFieldArray[i2];
                    Object object2 = SerializableConverter.this.readField(objectStreamField, classArray[0], object);
                    if (object2 == null) continue;
                    if (!blArray[0]) {
                        hierarchicalStreamWriter.startNode(SerializableConverter.this.mapper.serializedClass(classArray[0]));
                        blArray[0] = true;
                    }
                    if (!bl2) {
                        hierarchicalStreamWriter.startNode(SerializableConverter.ELEMENT_DEFAULT);
                        bl2 = true;
                    }
                    if (!SerializableConverter.this.mapper.shouldSerializeMember(classArray[0], objectStreamField.getName())) continue;
                    Class<?> clazz = object2.getClass();
                    ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, SerializableConverter.this.mapper.serializedMember(object.getClass(), objectStreamField.getName()), clazz);
                    Class clazz2 = SerializableConverter.this.mapper.defaultImplementationOf(objectStreamField.getType());
                    if (!clazz.equals(clazz2) && (string = SerializableConverter.this.mapper.aliasForSystemAttribute(SerializableConverter.ATTRIBUTE_CLASS)) != null) {
                        hierarchicalStreamWriter.addAttribute(string, SerializableConverter.this.mapper.serializedClass(clazz));
                    }
                    marshallingContext.convertAnother(object2);
                    hierarchicalStreamWriter.endNode();
                }
                if (blArray[0] && !bl2) {
                    hierarchicalStreamWriter.startNode(SerializableConverter.ELEMENT_DEFAULT);
                    hierarchicalStreamWriter.endNode();
                } else if (bl2) {
                    hierarchicalStreamWriter.endNode();
                }
            }

            public void flush() {
                hierarchicalStreamWriter.flush();
            }

            public void close() {
                throw new UnsupportedOperationException("Objects are not allowed to call ObjectOutputStream.close() from writeObject()");
            }
        };
        try {
            boolean bl2 = false;
            Iterator iterator = this.hierarchyFor(object.getClass()).iterator();
            while (iterator.hasNext()) {
                Object object2;
                classArray[0] = (Class)iterator.next();
                if (!Serializable.class.isAssignableFrom(classArray[0])) {
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    this.marshalUnserializableParent(hierarchicalStreamWriter, marshallingContext, object);
                    bl2 = false;
                }
                if (this.serializationMembers.supportsWriteObject(classArray[0], false)) {
                    blArray[0] = true;
                    hierarchicalStreamWriter.startNode(this.mapper.serializedClass(classArray[0]));
                    if (classArray[0] != this.mapper.defaultImplementationOf(classArray[0]) && (object2 = this.mapper.aliasForSystemAttribute(ATTRIBUTE_CLASS)) != null) {
                        hierarchicalStreamWriter.addAttribute((String)object2, classArray[0].getName());
                    }
                    object2 = CustomObjectOutputStream.getInstance(marshallingContext, streamCallback);
                    this.serializationMembers.callWriteObject(classArray[0], object, (ObjectOutputStream)object2);
                    ((CustomObjectOutputStream)object2).popCallback();
                    hierarchicalStreamWriter.endNode();
                    continue;
                }
                if (this.serializationMembers.supportsReadObject(classArray[0], false)) {
                    blArray[0] = true;
                    hierarchicalStreamWriter.startNode(this.mapper.serializedClass(classArray[0]));
                    if (classArray[0] != this.mapper.defaultImplementationOf(classArray[0]) && (object2 = this.mapper.aliasForSystemAttribute(ATTRIBUTE_CLASS)) != null) {
                        hierarchicalStreamWriter.addAttribute((String)object2, classArray[0].getName());
                    }
                    streamCallback.defaultWriteObject();
                    hierarchicalStreamWriter.endNode();
                    continue;
                }
                blArray[0] = false;
                streamCallback.defaultWriteObject();
                if (!blArray[0]) continue;
                hierarchicalStreamWriter.endNode();
            }
        }
        catch (IOException iOException) {
            throw new StreamException("Cannot write defaults", iOException);
        }
    }

    protected void marshalUnserializableParent(HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext, Object object) {
        hierarchicalStreamWriter.startNode(ELEMENT_UNSERIALIZABLE_PARENTS);
        super.doMarshal(object, hierarchicalStreamWriter, marshallingContext);
        hierarchicalStreamWriter.endNode();
    }

    private Object readField(ObjectStreamField objectStreamField, Class clazz, Object object) {
        Field field = Fields.find(clazz, objectStreamField.getName());
        return Fields.read(field, object);
    }

    protected List hierarchyFor(Class clazz) {
        ArrayList arrayList = new ArrayList();
        while (clazz != Object.class && clazz != null) {
            arrayList.add(clazz);
            clazz = clazz.getSuperclass();
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public Object doUnmarshal(final Object object, final HierarchicalStreamReader hierarchicalStreamReader, final UnmarshallingContext unmarshallingContext) {
        final Class[] classArray = new Class[1];
        String string = this.mapper.aliasForSystemAttribute(ATTRIBUTE_SERIALIZATION);
        if (string != null && !ATTRIBUTE_VALUE_CUSTOM.equals(hierarchicalStreamReader.getAttribute(string))) {
            throw new ConversionException("Cannot deserialize object with new readObject()/writeObject() methods");
        }
        CustomObjectInputStream.StreamCallback streamCallback = new CustomObjectInputStream.StreamCallback(){

            public Object readFromStream() {
                hierarchicalStreamReader.moveDown();
                Class clazz = HierarchicalStreams.readClassType(hierarchicalStreamReader, SerializableConverter.this.mapper);
                Object object2 = unmarshallingContext.convertAnother(object, clazz);
                hierarchicalStreamReader.moveUp();
                return object2;
            }

            public Map readFieldsFromStream() {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hierarchicalStreamReader.moveDown();
                if (hierarchicalStreamReader.getNodeName().equals(SerializableConverter.ELEMENT_FIELDS)) {
                    while (hierarchicalStreamReader.hasMoreChildren()) {
                        hierarchicalStreamReader.moveDown();
                        if (!hierarchicalStreamReader.getNodeName().equals(SerializableConverter.ELEMENT_FIELD)) {
                            throw new ConversionException("Expected <field/> element inside <field/>");
                        }
                        String string = hierarchicalStreamReader.getAttribute(SerializableConverter.ATTRIBUTE_NAME);
                        Class clazz = SerializableConverter.this.mapper.realClass(hierarchicalStreamReader.getAttribute(SerializableConverter.ATTRIBUTE_CLASS));
                        Object object2 = unmarshallingContext.convertAnother(object, clazz);
                        hashMap.put(string, object2);
                        hierarchicalStreamReader.moveUp();
                    }
                } else if (hierarchicalStreamReader.getNodeName().equals(SerializableConverter.ELEMENT_DEFAULT)) {
                    ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(classArray[0]);
                    while (hierarchicalStreamReader.hasMoreChildren()) {
                        hierarchicalStreamReader.moveDown();
                        String string = SerializableConverter.this.mapper.realMember(classArray[0], hierarchicalStreamReader.getNodeName());
                        if (SerializableConverter.this.mapper.shouldSerializeMember(classArray[0], string)) {
                            Object object3;
                            Class<?> clazz;
                            String string2 = HierarchicalStreams.readClassAttribute(hierarchicalStreamReader, SerializableConverter.this.mapper);
                            if (string2 != null) {
                                clazz = SerializableConverter.this.mapper.realClass(string2);
                            } else {
                                object3 = objectStreamClass.getField(string);
                                if (object3 == null) {
                                    throw new MissingFieldException(classArray[0].getName(), string);
                                }
                                clazz = ((ObjectStreamField)object3).getType();
                            }
                            object3 = unmarshallingContext.convertAnother(object, clazz);
                            hashMap.put(string, object3);
                        }
                        hierarchicalStreamReader.moveUp();
                    }
                } else {
                    throw new ConversionException("Expected <fields/> or <default/> element when calling ObjectInputStream.readFields()");
                }
                hierarchicalStreamReader.moveUp();
                return hashMap;
            }

            public void defaultReadObject() {
                if (SerializableConverter.this.serializationMembers.getSerializablePersistentFields(classArray[0]) != null) {
                    this.readFieldsFromStream();
                    return;
                }
                if (!hierarchicalStreamReader.hasMoreChildren()) {
                    return;
                }
                hierarchicalStreamReader.moveDown();
                if (!hierarchicalStreamReader.getNodeName().equals(SerializableConverter.ELEMENT_DEFAULT)) {
                    throw new ConversionException("Expected <default/> element in readObject() stream");
                }
                while (hierarchicalStreamReader.hasMoreChildren()) {
                    hierarchicalStreamReader.moveDown();
                    String string = SerializableConverter.this.mapper.realMember(classArray[0], hierarchicalStreamReader.getNodeName());
                    if (SerializableConverter.this.mapper.shouldSerializeMember(classArray[0], string)) {
                        String string2 = HierarchicalStreams.readClassAttribute(hierarchicalStreamReader, SerializableConverter.this.mapper);
                        Class clazz = string2 != null ? SerializableConverter.this.mapper.realClass(string2) : SerializableConverter.this.mapper.defaultImplementationOf(SerializableConverter.this.reflectionProvider.getFieldType(object, string, classArray[0]));
                        Object object2 = unmarshallingContext.convertAnother(object, clazz);
                        SerializableConverter.this.reflectionProvider.writeField(object, string, object2, classArray[0]);
                    }
                    hierarchicalStreamReader.moveUp();
                }
                hierarchicalStreamReader.moveUp();
            }

            public void registerValidation(final ObjectInputValidation objectInputValidation, int n2) {
                unmarshallingContext.addCompletionCallback(new Runnable(){

                    public void run() {
                        try {
                            objectInputValidation.validateObject();
                        }
                        catch (InvalidObjectException invalidObjectException) {
                            throw new ObjectAccessException("Cannot validate object", invalidObjectException);
                        }
                    }
                }, n2);
            }

            public void close() {
                throw new UnsupportedOperationException("Objects are not allowed to call ObjectInputStream.close() from readObject()");
            }
        };
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            String string2 = hierarchicalStreamReader.getNodeName();
            if (string2.equals(ELEMENT_UNSERIALIZABLE_PARENTS)) {
                super.doUnmarshal(object, hierarchicalStreamReader, unmarshallingContext);
            } else {
                String string3 = HierarchicalStreams.readClassAttribute(hierarchicalStreamReader, this.mapper);
                classArray[0] = string3 == null ? this.mapper.defaultImplementationOf(this.mapper.realClass(string2)) : this.mapper.realClass(string3);
                if (this.serializationMembers.supportsReadObject(classArray[0], false)) {
                    CustomObjectInputStream customObjectInputStream = CustomObjectInputStream.getInstance((DataHolder)unmarshallingContext, streamCallback, this.classLoaderReference);
                    this.serializationMembers.callReadObject(classArray[0], object, customObjectInputStream);
                    customObjectInputStream.popCallback();
                } else {
                    try {
                        streamCallback.defaultReadObject();
                    }
                    catch (IOException iOException) {
                        throw new StreamException("Cannot read defaults", iOException);
                    }
                }
            }
            hierarchicalStreamReader.moveUp();
        }
        return object;
    }

    protected void doMarshalConditionally(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        if (this.isSerializable(object.getClass())) {
            this.doMarshal(object, hierarchicalStreamWriter, marshallingContext);
        } else {
            super.doMarshal(object, hierarchicalStreamWriter, marshallingContext);
        }
    }

    protected Object doUnmarshalConditionally(Object object, HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        return this.isSerializable(object.getClass()) ? this.doUnmarshal(object, hierarchicalStreamReader, unmarshallingContext) : super.doUnmarshal(object, hierarchicalStreamReader, unmarshallingContext);
    }

    private static class UnserializableParentsReflectionProvider
    extends ReflectionProviderWrapper {
        public UnserializableParentsReflectionProvider(ReflectionProvider reflectionProvider) {
            super(reflectionProvider);
        }

        public void visitSerializableFields(Object object, final ReflectionProvider.Visitor visitor) {
            this.wrapped.visitSerializableFields(object, new ReflectionProvider.Visitor(){

                public void visit(String string, Class clazz, Class clazz2, Object object) {
                    if (!Serializable.class.isAssignableFrom(clazz2)) {
                        visitor.visit(string, clazz, clazz2, object);
                    }
                }
            });
        }
    }
}

