/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.reflection;

import java.lang.reflect.Field;
import sun.misc.Unsafe;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.ErrorWritingException;
import zz.com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;

public class SunLimitedUnsafeReflectionProvider
extends PureJavaReflectionProvider {
    protected static final Unsafe unsafe;
    protected static final Exception exception;

    public SunLimitedUnsafeReflectionProvider() {
    }

    public SunLimitedUnsafeReflectionProvider(FieldDictionary fieldDictionary) {
        super(fieldDictionary);
    }

    public Object newInstance(Class clazz) {
        if (exception != null) {
            ObjectAccessException objectAccessException = new ObjectAccessException("Cannot construct type", exception);
            objectAccessException.add("construction-type", clazz.getName());
            throw objectAccessException;
        }
        ErrorWritingException errorWritingException = null;
        if (clazz == Void.TYPE || clazz == Void.class) {
            errorWritingException = new ConversionException("Type void cannot have an instance");
        } else {
            try {
                return unsafe.allocateInstance(clazz);
            }
            catch (SecurityException securityException) {
                errorWritingException = new ObjectAccessException("Cannot construct type", securityException);
            }
            catch (InstantiationException instantiationException) {
                errorWritingException = new ConversionException("Cannot construct type", instantiationException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errorWritingException = new ObjectAccessException("Cannot construct type", illegalArgumentException);
            }
        }
        errorWritingException.add("construction-type", clazz.getName());
        throw errorWritingException;
    }

    protected void validateFieldAccess(Field field) {
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    static {
        Unsafe unsafe = null;
        Exception exception = null;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            exception = noSuchFieldException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        SunLimitedUnsafeReflectionProvider.exception = exception;
        SunLimitedUnsafeReflectionProvider.unsafe = unsafe;
    }
}

