/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.reflection;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.WeakHashMap;
import zz.com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.converters.reflection.SunLimitedUnsafeReflectionProvider;

public class SunUnsafeReflectionProvider
extends SunLimitedUnsafeReflectionProvider {
    private transient Map fieldOffsetCache;

    public SunUnsafeReflectionProvider() {
    }

    public SunUnsafeReflectionProvider(FieldDictionary fieldDictionary) {
        super(fieldDictionary);
    }

    public void writeField(Object object, String string, Object object2, Class clazz) {
        this.write(this.fieldDictionary.field(object.getClass(), string, clazz), object, object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(Field field, Object object, Object object2) {
        if (exception != null) {
            ObjectAccessException objectAccessException = new ObjectAccessException("Cannot set field", exception);
            objectAccessException.add("field", object.getClass() + "." + field.getName());
            throw objectAccessException;
        }
        try {
            long l2 = this.getFieldOffset(field);
            Class<?> clazz = field.getType();
            if (!clazz.isPrimitive()) {
                unsafe.putObject(object, l2, object2);
                return;
            }
            if (clazz.equals(Integer.TYPE)) {
                unsafe.putInt(object, l2, (Integer)object2);
                return;
            }
            if (clazz.equals(Long.TYPE)) {
                unsafe.putLong(object, l2, (Long)object2);
                return;
            }
            if (clazz.equals(Short.TYPE)) {
                unsafe.putShort(object, l2, (Short)object2);
                return;
            }
            if (clazz.equals(Character.TYPE)) {
                unsafe.putChar(object, l2, ((Character)object2).charValue());
                return;
            }
            if (clazz.equals(Byte.TYPE)) {
                unsafe.putByte(object, l2, (Byte)object2);
                return;
            }
            if (clazz.equals(Float.TYPE)) {
                unsafe.putFloat(object, l2, ((Float)object2).floatValue());
                return;
            }
            if (clazz.equals(Double.TYPE)) {
                unsafe.putDouble(object, l2, (Double)object2);
                return;
            }
            if (clazz.equals(Boolean.TYPE)) {
                unsafe.putBoolean(object, l2, (Boolean)object2);
                return;
            }
            ObjectAccessException objectAccessException = new ObjectAccessException("Cannot set field of unknown type", exception);
            objectAccessException.add("field", object.getClass() + "." + field.getName());
            objectAccessException.add("unknown-type", clazz.getName());
            throw objectAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ObjectAccessException objectAccessException = new ObjectAccessException("Cannot set field", illegalArgumentException);
            objectAccessException.add("field", object.getClass() + "." + field.getName());
            throw objectAccessException;
        }
    }

    private synchronized long getFieldOffset(Field field) {
        Long l2 = (Long)this.fieldOffsetCache.get(field);
        if (l2 == null) {
            l2 = new Long(unsafe.objectFieldOffset(field));
            this.fieldOffsetCache.put(field, l2);
        }
        return l2;
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    protected void init() {
        super.init();
        this.fieldOffsetCache = new WeakHashMap();
    }
}

