/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.time;

import java.time.DateTimeException;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.ErrorWritingException;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;

abstract class AbstractChronoLocalDateConverter<E extends Era>
extends AbstractSingleValueConverter {
    private static final Pattern CHRONO_DATE_PATTERN = Pattern.compile("^ (\\w+) (\\d+)-(\\d+)-(\\d+)$");

    AbstractChronoLocalDateConverter() {
    }

    protected abstract ChronoLocalDate chronoLocalDateOf(E var1, int var2, int var3, int var4);

    protected abstract E eraOf(String var1);

    protected ChronoLocalDate parseChronoLocalDate(String string, String string2, Set<Chronology> set) {
        if (string == null) {
            return null;
        }
        ErrorWritingException errorWritingException = null;
        for (Chronology chronology : set) {
            Matcher matcher;
            String string3 = chronology.getId();
            if (!string.startsWith(string3 + ' ') || !(matcher = CHRONO_DATE_PATTERN.matcher(string.subSequence(string3.length(), string.length()))).matches()) continue;
            E e2 = null;
            try {
                e2 = this.eraOf(matcher.group(1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errorWritingException = new ConversionException("Cannot parse value as " + string2 + " date", illegalArgumentException);
                break;
            }
            if (e2 == null) continue;
            try {
                return this.chronoLocalDateOf(e2, Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
            }
            catch (DateTimeException dateTimeException) {
                errorWritingException = new ConversionException("Cannot parse value as " + string2 + " date", dateTimeException);
                break;
            }
        }
        if (errorWritingException == null) {
            errorWritingException = new ConversionException("Cannot parse value as " + string2 + " date");
        }
        errorWritingException.add("value", string);
        throw errorWritingException;
    }
}

