/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.time;

import java.time.DateTimeException;
import java.time.chrono.Chronology;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;

public class ChronologyConverter
implements SingleValueConverter {
    @Override
    public boolean canConvert(Class clazz) {
        return Chronology.class.isAssignableFrom(clazz);
    }

    @Override
    public Chronology fromString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Chronology.of(string);
        }
        catch (DateTimeException dateTimeException) {
            ConversionException conversionException = new ConversionException("Cannot parse value as chronology", dateTimeException);
            conversionException.add("value", string);
            throw conversionException;
        }
    }

    @Override
    public String toString(Object object) {
        return object == null ? null : ((Chronology)object).getId();
    }
}

