/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.time;

import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.HijrahChronology;
import java.time.chrono.HijrahDate;
import java.time.chrono.HijrahEra;
import java.util.HashSet;
import java.util.Set;
import zz.com.thoughtworks.xstream.converters.time.AbstractChronoLocalDateConverter;

public class HijrahDateConverter
extends AbstractChronoLocalDateConverter<HijrahEra> {
    private final Set<Chronology> hijrahChronologies = new HashSet<Chronology>();

    public HijrahDateConverter() {
        Set<Chronology> set = Chronology.getAvailableChronologies();
        for (Chronology chronology : set) {
            if (!(chronology instanceof HijrahChronology)) continue;
            this.hijrahChronologies.add(chronology);
        }
    }

    @Override
    public boolean canConvert(Class clazz) {
        return HijrahDate.class == clazz;
    }

    @Override
    public Object fromString(String string) {
        return this.parseChronoLocalDate(string, "Hijrah", this.hijrahChronologies);
    }

    @Override
    protected ChronoLocalDate chronoLocalDateOf(HijrahEra hijrahEra, int n2, int n3, int n4) {
        return hijrahEra != null ? HijrahDate.of(n2, n3, n4) : null;
    }

    @Override
    protected HijrahEra eraOf(String string) {
        return HijrahEra.valueOf(string);
    }
}

