/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.time;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;

public class LocalTimeConverter
implements SingleValueConverter {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();

    @Override
    public boolean canConvert(Class clazz) {
        return LocalTime.class == clazz;
    }

    @Override
    public Object fromString(String string) {
        try {
            return LocalTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            ConversionException conversionException = new ConversionException("Cannot parse value as local time", dateTimeParseException);
            conversionException.add("value", string);
            throw conversionException;
        }
    }

    @Override
    public String toString(Object object) {
        if (object == null) {
            return null;
        }
        LocalTime localTime = (LocalTime)object;
        return FORMATTER.format(localTime);
    }
}

