/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.time;

import java.time.Clock;
import java.time.ZoneId;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class SystemClockConverter
implements Converter {
    private final Mapper mapper;
    private final Class<?> type;

    public SystemClockConverter(Mapper mapper) {
        this.mapper = mapper;
        this.type = Clock.systemUTC().getClass();
    }

    @Override
    public boolean canConvert(Class clazz) {
        return clazz == this.type;
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Clock clock = (Clock)object;
        ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, this.mapper.serializedMember(Clock.class, "zone"), null);
        marshallingContext.convertAnother(clock.getZone());
        hierarchicalStreamWriter.endNode();
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        hierarchicalStreamReader.moveDown();
        ZoneId zoneId = (ZoneId)unmarshallingContext.convertAnother(null, ZoneId.class);
        hierarchicalStreamReader.moveUp();
        return Clock.system(zoneId);
    }
}

