/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.time;

import java.time.temporal.ValueRange;
import java.util.HashMap;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class ValueRangeConverter
implements Converter {
    private final Mapper mapper;

    public ValueRangeConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean canConvert(Class clazz) {
        return clazz == ValueRange.class;
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        ValueRange valueRange = (ValueRange)object;
        this.write("maxLargest", valueRange.getMaximum(), hierarchicalStreamWriter);
        this.write("maxSmallest", valueRange.getSmallestMaximum(), hierarchicalStreamWriter);
        this.write("minLargest", valueRange.getLargestMinimum(), hierarchicalStreamWriter);
        this.write("minSmallest", valueRange.getMinimum(), hierarchicalStreamWriter);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        boolean bl2 = "custom".equals(hierarchicalStreamReader.getAttribute(this.mapper.aliasForSystemAttribute("serialization")));
        if (bl2) {
            hierarchicalStreamReader.moveDown();
            hierarchicalStreamReader.moveDown();
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            String string = hierarchicalStreamReader.getNodeName();
            hashMap.put(bl2 ? string : this.mapper.realMember(ValueRange.class, string), Long.valueOf(hierarchicalStreamReader.getValue()));
            hierarchicalStreamReader.moveUp();
        }
        if (bl2) {
            hierarchicalStreamReader.moveUp();
            hierarchicalStreamReader.moveUp();
        }
        return ValueRange.of((Long)hashMap.get("minSmallest"), (Long)hashMap.get("minLargest"), (Long)hashMap.get("maxSmallest"), (Long)hashMap.get("maxLargest"));
    }

    private void write(String string, long l2, HierarchicalStreamWriter hierarchicalStreamWriter) {
        ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, this.mapper.serializedMember(ValueRange.class, string), Long.TYPE);
        hierarchicalStreamWriter.setValue(String.valueOf(l2));
        hierarchicalStreamWriter.endNode();
    }
}

