/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.time;

import java.time.DayOfWeek;
import java.time.temporal.WeekFields;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class WeekFieldsConverter
implements Converter {
    private final Mapper mapper;

    public WeekFieldsConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean canConvert(Class clazz) {
        return clazz == WeekFields.class;
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        WeekFields weekFields = (WeekFields)object;
        ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, this.mapper.serializedMember(WeekFields.class, "minimalDays"), Integer.TYPE);
        hierarchicalStreamWriter.setValue(String.valueOf(weekFields.getMinimalDaysInFirstWeek()));
        hierarchicalStreamWriter.endNode();
        ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, this.mapper.serializedMember(WeekFields.class, "firstDayOfWeek"), DayOfWeek.class);
        marshallingContext.convertAnother(weekFields.getFirstDayOfWeek());
        hierarchicalStreamWriter.endNode();
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        boolean bl2 = "custom".equals(hierarchicalStreamReader.getAttribute(this.mapper.aliasForSystemAttribute("serialization")));
        if (bl2) {
            hierarchicalStreamReader.moveDown();
            hierarchicalStreamReader.moveDown();
        }
        int n2 = 0;
        DayOfWeek dayOfWeek = null;
        while (hierarchicalStreamReader.hasMoreChildren()) {
            String string;
            hierarchicalStreamReader.moveDown();
            String string2 = string = bl2 ? hierarchicalStreamReader.getNodeName() : this.mapper.realMember(WeekFields.class, hierarchicalStreamReader.getNodeName());
            if ("minimalDays".equals(string)) {
                n2 = Integer.parseInt(hierarchicalStreamReader.getValue());
            } else if ("firstDayOfWeek".equals(string)) {
                dayOfWeek = (DayOfWeek)unmarshallingContext.convertAnother(null, DayOfWeek.class);
            } else {
                throw new AbstractReflectionConverter.UnknownFieldException(WeekFields.class.getName(), string);
            }
            hierarchicalStreamReader.moveUp();
        }
        if (bl2) {
            hierarchicalStreamReader.moveUp();
            hierarchicalStreamReader.moveUp();
        }
        return WeekFields.of(dayOfWeek, n2);
    }
}

