/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.time;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.zone.ZoneRulesException;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;

public class ZoneIdConverter
implements SingleValueConverter {
    @Override
    public boolean canConvert(Class clazz) {
        return ZoneId.class.isAssignableFrom(clazz);
    }

    @Override
    public ZoneId fromString(String string) {
        ConversionException conversionException;
        try {
            return ZoneId.of(string);
        }
        catch (ZoneRulesException zoneRulesException) {
            conversionException = new ConversionException("Not a valid zone id", zoneRulesException);
        }
        catch (DateTimeException dateTimeException) {
            conversionException = new ConversionException("Cannot parse value as zone id", dateTimeException);
        }
        conversionException.add("value", string);
        throw conversionException;
    }

    @Override
    public String toString(Object object) {
        if (object == null) {
            return null;
        }
        ZoneId zoneId = (ZoneId)object;
        return zoneId.getId();
    }
}

