/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.time;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;

public class ZonedDateTimeConverter
implements SingleValueConverter {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendOffsetId().appendLiteral("[").appendZoneId().appendLiteral("]").toFormatter();

    @Override
    public boolean canConvert(Class clazz) {
        return ZonedDateTime.class == clazz;
    }

    @Override
    public String toString(Object object) {
        if (object == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = (ZonedDateTime)object;
        return FORMATTER.format(zonedDateTime);
    }

    @Override
    public Object fromString(String string) {
        try {
            return ZonedDateTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            ConversionException conversionException = new ConversionException("Cannot parse value as zoned date time", dateTimeParseException);
            conversionException.add("value", string);
            throw conversionException;
        }
    }
}

