/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core;

import java.util.Iterator;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.core.ReferencingMarshallingContext;
import zz.com.thoughtworks.xstream.core.TreeMarshaller;
import zz.com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.path.Path;
import zz.com.thoughtworks.xstream.io.path.PathTracker;
import zz.com.thoughtworks.xstream.io.path.PathTrackingWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public abstract class AbstractReferenceMarshaller
extends TreeMarshaller
implements MarshallingContext {
    private ObjectIdDictionary references = new ObjectIdDictionary();
    private ObjectIdDictionary implicitElements = new ObjectIdDictionary();
    private PathTracker pathTracker = new PathTracker();
    private Path lastPath;

    public AbstractReferenceMarshaller(HierarchicalStreamWriter hierarchicalStreamWriter, ConverterLookup converterLookup, Mapper mapper) {
        super(hierarchicalStreamWriter, converterLookup, mapper);
        this.writer = new PathTrackingWriter(hierarchicalStreamWriter, this.pathTracker);
    }

    public void convert(Object object, Converter converter) {
        if (this.getMapper().isImmutableValueType(object.getClass())) {
            converter.marshal(object, this.writer, this);
        } else {
            final Path path = this.pathTracker.getPath();
            Id id = (Id)this.references.lookupId(object);
            if (id != null && id.getPath() != path) {
                String string = this.getMapper().aliasForSystemAttribute("reference");
                if (string != null) {
                    this.writer.addAttribute(string, this.createReference(path, id.getItem()));
                }
            } else {
                Object object2;
                Object object3 = object2 = id == null ? this.createReferenceKey(path, object) : id.getItem();
                if (this.lastPath == null || !path.isAncestor(this.lastPath)) {
                    this.fireValidReference(object2);
                    this.lastPath = path;
                    this.references.associateId(object, new Id(object2, path));
                }
                converter.marshal(object, this.writer, new ReferencingMarshallingContext(){

                    public void put(Object object, Object object22) {
                        AbstractReferenceMarshaller.this.put(object, object22);
                    }

                    public Iterator keys() {
                        return AbstractReferenceMarshaller.this.keys();
                    }

                    public Object get(Object object) {
                        return AbstractReferenceMarshaller.this.get(object);
                    }

                    public void convertAnother(Object object, Converter converter) {
                        AbstractReferenceMarshaller.this.convertAnother(object, converter);
                    }

                    public void convertAnother(Object object) {
                        AbstractReferenceMarshaller.this.convertAnother(object);
                    }

                    public void replace(Object object, Object object22) {
                        AbstractReferenceMarshaller.this.references.associateId(object22, new Id(object2, path));
                    }

                    public Object lookupReference(Object object) {
                        Id id = (Id)AbstractReferenceMarshaller.this.references.lookupId(object);
                        return id.getItem();
                    }

                    public Path currentPath() {
                        return AbstractReferenceMarshaller.this.pathTracker.getPath();
                    }

                    public void registerImplicit(Object object) {
                        if (AbstractReferenceMarshaller.this.implicitElements.containsId(object)) {
                            throw new ReferencedImplicitElementException(object, path);
                        }
                        AbstractReferenceMarshaller.this.implicitElements.associateId(object, object2);
                    }
                });
            }
        }
    }

    protected abstract String createReference(Path var1, Object var2);

    protected abstract Object createReferenceKey(Path var1, Object var2);

    protected abstract void fireValidReference(Object var1);

    public static class ReferencedImplicitElementException
    extends ConversionException {
        public ReferencedImplicitElementException(Object object, Path path) {
            super("Cannot reference implicit element");
            this.add("implicit-element", object.toString());
            this.add("referencing-element", path.toString());
        }
    }

    private static class Id {
        private Object item;
        private Path path;

        public Id(Object object, Path path) {
            this.item = object;
            this.path = path;
        }

        protected Object getItem() {
            return this.item;
        }

        protected Path getPath() {
            return this.path;
        }
    }
}

