/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.ConverterRegistry;
import zz.com.thoughtworks.xstream.converters.ErrorWritingException;
import zz.com.thoughtworks.xstream.core.Caching;
import zz.com.thoughtworks.xstream.core.util.PrioritizedList;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class DefaultConverterLookup
implements ConverterLookup,
ConverterRegistry,
Caching {
    private final PrioritizedList converters = new PrioritizedList();
    private transient Map typeToConverterMap;

    public DefaultConverterLookup() {
        this.readResolve();
    }

    public DefaultConverterLookup(Mapper mapper) {
    }

    public Converter lookupConverterForType(Class clazz) {
        Object object;
        Converter converter = (Converter)this.typeToConverterMap.get(clazz);
        if (converter != null) {
            return converter;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Iterator iterator = this.converters.iterator();
        while (iterator.hasNext()) {
            object = (Converter)iterator.next();
            try {
                if (!object.canConvert(clazz)) continue;
                this.typeToConverterMap.put(clazz, object);
                return object;
            }
            catch (RuntimeException runtimeException) {
                linkedHashMap.put(object.getClass().getName(), runtimeException.getMessage());
            }
            catch (LinkageError linkageError) {
                linkedHashMap.put(object.getClass().getName(), linkageError.getMessage());
            }
        }
        object = new ConversionException(linkedHashMap.isEmpty() ? "No converter specified" : "No converter available");
        ((ErrorWritingException)object).add("type", clazz.getName());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            ((ErrorWritingException)object).add("converter", entry.getKey().toString());
            ((ErrorWritingException)object).add("message", entry.getValue().toString());
        }
        throw object;
    }

    public void registerConverter(Converter converter, int n2) {
        this.converters.add(converter, n2);
        Iterator iterator = this.typeToConverterMap.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            try {
                if (!converter.canConvert(clazz)) continue;
                iterator.remove();
            }
            catch (RuntimeException runtimeException) {
            }
            catch (LinkageError linkageError) {}
        }
    }

    public void flushCache() {
        this.typeToConverterMap.clear();
        Iterator iterator = this.converters.iterator();
        while (iterator.hasNext()) {
            Converter converter = (Converter)iterator.next();
            if (!(converter instanceof Caching)) continue;
            ((Caching)((Object)converter)).flushCache();
        }
    }

    private Object readResolve() {
        this.typeToConverterMap = Collections.synchronizedMap(new WeakHashMap());
        return this;
    }
}

