/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.AttributedString;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;
import zz.com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.core.Caching;
import zz.com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import zz.com.thoughtworks.xstream.core.util.DependencyInjectionFactory;
import zz.com.thoughtworks.xstream.core.util.PresortedMap;
import zz.com.thoughtworks.xstream.core.util.PresortedSet;

public class JVM
implements Caching {
    private ReflectionProvider reflectionProvider;
    private static final boolean isAWTAvailable;
    private static final boolean isSwingAvailable;
    private static final boolean isSQLAvailable;
    private static final boolean canAllocateWithUnsafe;
    private static final boolean canWriteWithUnsafe;
    private static final boolean optimizedTreeSetAddAll;
    private static final boolean optimizedTreeMapPutAll;
    private static final boolean canParseUTCDateFormat;
    private static final boolean canParseISO8601TimeZoneInDateFormat;
    private static final boolean canCreateDerivedObjectOutputStream;
    private static final String vendor;
    private static final float majorJavaVersion;
    private static final float DEFAULT_JAVA_VERSION = 1.4f;
    private static final boolean reverseFieldOrder = false;
    private static final Class reflectionProviderType;

    private static final float getMajorJavaVersion() {
        try {
            return JVM.isAndroid() ? 1.5f : Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException numberFormatException) {
            return 1.4f;
        }
    }

    public static boolean is14() {
        return majorJavaVersion >= 1.4f;
    }

    public static boolean is15() {
        return majorJavaVersion >= 1.5f;
    }

    public static boolean is16() {
        return majorJavaVersion >= 1.6f;
    }

    public static boolean is17() {
        return majorJavaVersion >= 1.7f;
    }

    public static boolean is18() {
        return majorJavaVersion >= 1.8f;
    }

    public static boolean is19() {
        return majorJavaVersion >= 1.9f;
    }

    public static boolean is9() {
        return majorJavaVersion >= 9.0f;
    }

    private static boolean isIBM() {
        return vendor.indexOf("IBM") != -1;
    }

    private static boolean isAndroid() {
        return vendor.indexOf("Android") != -1;
    }

    public static Class loadClassForName(String string) {
        return JVM.loadClassForName(string, true);
    }

    public Class loadClass(String string) {
        return JVM.loadClassForName(string, true);
    }

    public static Class loadClassForName(String string, boolean bl2) {
        try {
            Class<?> clazz = Class.forName(string, bl2, JVM.class.getClassLoader());
            return clazz;
        }
        catch (LinkageError linkageError) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Class loadClass(String string, boolean bl2) {
        return JVM.loadClassForName(string, bl2);
    }

    public static ReflectionProvider newReflectionProvider() {
        return (ReflectionProvider)DependencyInjectionFactory.newInstance(reflectionProviderType, null);
    }

    public static ReflectionProvider newReflectionProvider(FieldDictionary fieldDictionary) {
        return (ReflectionProvider)DependencyInjectionFactory.newInstance(reflectionProviderType, new Object[]{fieldDictionary});
    }

    public static Class getStaxInputFactory() throws ClassNotFoundException {
        if (JVM.is16()) {
            if (JVM.isIBM()) {
                return Class.forName("zz.com.ibm.xml.xlxp.api.stax.XMLInputFactoryImpl");
            }
            return Class.forName("zz.com.sun.xml.internal.stream.XMLInputFactoryImpl");
        }
        return null;
    }

    public static Class getStaxOutputFactory() throws ClassNotFoundException {
        if (JVM.is16()) {
            if (JVM.isIBM()) {
                return Class.forName("zz.com.ibm.xml.xlxp.api.stax.XMLOutputFactoryImpl");
            }
            return Class.forName("zz.com.sun.xml.internal.stream.XMLOutputFactoryImpl");
        }
        return null;
    }

    public synchronized ReflectionProvider bestReflectionProvider() {
        if (this.reflectionProvider == null) {
            this.reflectionProvider = JVM.newReflectionProvider();
        }
        return this.reflectionProvider;
    }

    private static boolean canUseSunUnsafeReflectionProvider() {
        return canAllocateWithUnsafe && JVM.is14();
    }

    private static boolean canUseSunLimitedUnsafeReflectionProvider() {
        return canWriteWithUnsafe;
    }

    public static boolean reverseFieldDefinition() {
        return false;
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public boolean supportsAWT() {
        return isAWTAvailable;
    }

    public static boolean isSwingAvailable() {
        return isSwingAvailable;
    }

    public boolean supportsSwing() {
        return isSwingAvailable;
    }

    public static boolean isSQLAvailable() {
        return isSQLAvailable;
    }

    public boolean supportsSQL() {
        return isSQLAvailable;
    }

    public static boolean hasOptimizedTreeSetAddAll() {
        return optimizedTreeSetAddAll;
    }

    public static boolean hasOptimizedTreeMapPutAll() {
        return optimizedTreeMapPutAll;
    }

    public static boolean canParseUTCDateFormat() {
        return canParseUTCDateFormat;
    }

    public static boolean canParseISO8601TimeZoneInDateFormat() {
        return canParseISO8601TimeZoneInDateFormat;
    }

    public static boolean canCreateDerivedObjectOutputStream() {
        return canCreateDerivedObjectOutputStream;
    }

    public void flushCache() {
    }

    public static void main(String[] stringArray) {
        boolean bl2;
        boolean bl3 = false;
        Field[] fieldArray = AttributedString.class.getDeclaredFields();
        for (bl2 = false; bl2 < fieldArray.length; bl2 += 1) {
            if (!fieldArray[bl2].getName().equals("text")) continue;
            bl3 = bl2 > 3 != 0;
            break;
        }
        bl2 = false;
        fieldArray = Test.class.getDeclaredFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            if (!fieldArray[i2].getName().equals("o")) continue;
            bl2 = i2 > 3;
            break;
        }
        String string = null;
        try {
            string = JVM.getStaxInputFactory().getName();
        }
        catch (ClassNotFoundException classNotFoundException) {
            string = classNotFoundException.getMessage();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String string2 = null;
        try {
            string2 = JVM.getStaxOutputFactory().getName();
        }
        catch (ClassNotFoundException classNotFoundException) {
            string2 = classNotFoundException.getMessage();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        System.out.println("XStream JVM diagnostics");
        System.out.println("java.specification.version: " + System.getProperty("java.specification.version"));
        System.out.println("java.specification.vendor: " + System.getProperty("java.specification.vendor"));
        System.out.println("java.specification.name: " + System.getProperty("java.specification.name"));
        System.out.println("java.vm.vendor: " + vendor);
        System.out.println("java.vendor: " + System.getProperty("java.vendor"));
        System.out.println("java.vm.name: " + System.getProperty("java.vm.name"));
        System.out.println("Version: " + majorJavaVersion);
        System.out.println("XStream support for enhanced Mode: " + JVM.canUseSunUnsafeReflectionProvider());
        System.out.println("XStream support for reduced Mode: " + JVM.canUseSunLimitedUnsafeReflectionProvider());
        System.out.println("Supports AWT: " + JVM.isAWTAvailable());
        System.out.println("Supports Swing: " + JVM.isSwingAvailable());
        System.out.println("Supports SQL: " + JVM.isSQLAvailable());
        System.out.println("Java Beans EventHandler present: " + (JVM.loadClassForName("java.beans.EventHandler") != null));
        System.out.println("Standard StAX XMLInputFactory: " + string);
        System.out.println("Standard StAX XMLOutputFactory: " + string2);
        System.out.println("Optimized TreeSet.addAll: " + JVM.hasOptimizedTreeSetAddAll());
        System.out.println("Optimized TreeMap.putAll: " + JVM.hasOptimizedTreeMapPutAll());
        System.out.println("Can parse UTC date format: " + JVM.canParseUTCDateFormat());
        System.out.println("Can create derive ObjectOutputStream: " + JVM.canCreateDerivedObjectOutputStream());
        System.out.println("Reverse field order detected for JDK: " + bl3);
        System.out.println("Reverse field order detected (only if JVM class itself has been compiled): " + bl2);
    }

    static {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        vendor = System.getProperty("java.vm.vendor");
        majorJavaVersion = JVM.getMajorJavaVersion();
        boolean bl2 = true;
        Object object5 = null;
        try {
            object4 = Class.forName("sun.misc.Unsafe");
            object3 = ((Class)object4).getDeclaredField("theUnsafe");
            ((Field)object3).setAccessible(true);
            object5 = ((Field)object3).get(null);
            object2 = ((Class)object4).getDeclaredMethod("allocateInstance", Class.class);
            ((Method)object2).setAccessible(true);
            bl2 = ((Method)object2).invoke(object5, Test.class) != null;
        }
        catch (Exception exception) {
            bl2 = false;
        }
        catch (Error error) {
            bl2 = false;
        }
        canAllocateWithUnsafe = bl2;
        bl2 = false;
        object4 = PureJavaReflectionProvider.class;
        if (JVM.canUseSunUnsafeReflectionProvider() && (object3 = JVM.loadClassForName("zz.com.thoughtworks.xstream.converters.reflection.SunUnsafeReflectionProvider")) != null) {
            try {
                object2 = (ReflectionProvider)DependencyInjectionFactory.newInstance((Class)object3, null);
                object = (Test)object2.newInstance(Test.class);
                try {
                    object2.writeField(object, "o", "object", Test.class);
                    object2.writeField(object, "c", new Character('c'), Test.class);
                    object2.writeField(object, "b", new Byte(1), Test.class);
                    object2.writeField(object, "s", new Short(1), Test.class);
                    object2.writeField(object, "i", new Integer(1), Test.class);
                    object2.writeField(object, "l", new Long(1L), Test.class);
                    object2.writeField(object, "f", new Float(1.0f), Test.class);
                    object2.writeField(object, "d", new Double(1.0), Test.class);
                    object2.writeField(object, "bool", Boolean.TRUE, Test.class);
                    bl2 = true;
                }
                catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                    object3 = null;
                }
                catch (ObjectAccessException objectAccessException) {
                    object3 = null;
                }
                if (object3 == null) {
                    object3 = JVM.loadClassForName("zz.com.thoughtworks.xstream.converters.reflection.SunLimitedUnsafeReflectionProvider");
                }
                object4 = object3;
            }
            catch (ObjectAccessException objectAccessException) {
                // empty catch block
            }
        }
        reflectionProviderType = object4;
        canWriteWithUnsafe = bl2;
        object3 = new Comparator(){

            public int compare(Object object, Object object2) {
                throw new RuntimeException();
            }
        };
        object2 = new PresortedMap((Comparator)object3);
        object2.put("one", null);
        object2.put("two", null);
        try {
            new TreeMap(object3).putAll(object2);
            bl2 = true;
        }
        catch (RuntimeException runtimeException) {
            bl2 = false;
        }
        optimizedTreeMapPutAll = bl2;
        object = new PresortedSet((Comparator)object3);
        object.addAll(object2.keySet());
        try {
            new TreeSet(object3).addAll(object);
            bl2 = true;
        }
        catch (RuntimeException runtimeException) {
            bl2 = false;
        }
        optimizedTreeSetAddAll = bl2;
        try {
            new SimpleDateFormat("z").parse("UTC");
            bl2 = true;
        }
        catch (ParseException parseException) {
            bl2 = false;
        }
        canParseUTCDateFormat = bl2;
        try {
            new SimpleDateFormat("X").parse("Z");
            bl2 = true;
        }
        catch (ParseException parseException) {
            bl2 = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl2 = false;
        }
        canParseISO8601TimeZoneInDateFormat = bl2;
        try {
            bl2 = new CustomObjectOutputStream(null) != null;
        }
        catch (RuntimeException runtimeException) {
            bl2 = false;
        }
        catch (IOException iOException) {
            bl2 = false;
        }
        canCreateDerivedObjectOutputStream = bl2;
        isAWTAvailable = JVM.loadClassForName("java.awt.Color", false) != null;
        isSwingAvailable = JVM.loadClassForName("javax.swing.LookAndFeel", false) != null;
        isSQLAvailable = JVM.loadClassForName("java.sql.Date") != null;
    }

    static class Test {
        private Object o;
        private char c;
        private byte b;
        private short s;
        private int i;
        private long l;
        private float f;
        private double d;
        private boolean bool;

        Test() {
            throw new UnsupportedOperationException();
        }
    }
}

