/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core;

import java.util.Iterator;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.DataHolder;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.core.MapBackedDataHolder;
import zz.com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class TreeMarshaller
implements MarshallingContext {
    protected HierarchicalStreamWriter writer;
    protected ConverterLookup converterLookup;
    private Mapper mapper;
    private ObjectIdDictionary parentObjects = new ObjectIdDictionary();
    private DataHolder dataHolder;

    public TreeMarshaller(HierarchicalStreamWriter hierarchicalStreamWriter, ConverterLookup converterLookup, Mapper mapper) {
        this.writer = hierarchicalStreamWriter;
        this.converterLookup = converterLookup;
        this.mapper = mapper;
    }

    public void convertAnother(Object object) {
        this.convertAnother(object, null);
    }

    public void convertAnother(Object object, Converter converter) {
        if (converter == null) {
            converter = this.converterLookup.lookupConverterForType(object.getClass());
        } else if (!converter.canConvert(object.getClass())) {
            ConversionException conversionException = new ConversionException("Explicit selected converter cannot handle item");
            conversionException.add("item-type", object.getClass().getName());
            conversionException.add("converter-type", converter.getClass().getName());
            throw conversionException;
        }
        this.convert(object, converter);
    }

    protected void convert(Object object, Converter converter) {
        if (this.parentObjects.containsId(object)) {
            CircularReferenceException circularReferenceException = new CircularReferenceException("Recursive reference to parent object");
            circularReferenceException.add("item-type", object.getClass().getName());
            circularReferenceException.add("converter-type", converter.getClass().getName());
            throw circularReferenceException;
        }
        this.parentObjects.associateId(object, "");
        converter.marshal(object, this.writer, this);
        this.parentObjects.removeId(object);
    }

    public void start(Object object, DataHolder dataHolder) {
        this.dataHolder = dataHolder;
        if (object == null) {
            this.writer.startNode(this.mapper.serializedClass(null));
            this.writer.endNode();
        } else {
            ExtendedHierarchicalStreamWriterHelper.startNode(this.writer, this.mapper.serializedClass(object.getClass()), object.getClass());
            this.convertAnother(object);
            this.writer.endNode();
        }
    }

    public Object get(Object object) {
        this.lazilyCreateDataHolder();
        return this.dataHolder.get(object);
    }

    public void put(Object object, Object object2) {
        this.lazilyCreateDataHolder();
        this.dataHolder.put(object, object2);
    }

    public Iterator keys() {
        this.lazilyCreateDataHolder();
        return this.dataHolder.keys();
    }

    private void lazilyCreateDataHolder() {
        if (this.dataHolder == null) {
            this.dataHolder = new MapBackedDataHolder();
        }
    }

    protected Mapper getMapper() {
        return this.mapper;
    }

    public static class CircularReferenceException
    extends ConversionException {
        public CircularReferenceException(String string) {
            super(string);
        }
    }
}

