/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core;

import java.util.Iterator;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.DataHolder;
import zz.com.thoughtworks.xstream.converters.ErrorReporter;
import zz.com.thoughtworks.xstream.converters.ErrorWriter;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.core.MapBackedDataHolder;
import zz.com.thoughtworks.xstream.core.util.FastStack;
import zz.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import zz.com.thoughtworks.xstream.core.util.PrioritizedList;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class TreeUnmarshaller
implements UnmarshallingContext {
    private Object root;
    protected HierarchicalStreamReader reader;
    private ConverterLookup converterLookup;
    private Mapper mapper;
    private FastStack types = new FastStack(16);
    private DataHolder dataHolder;
    private final PrioritizedList validationList = new PrioritizedList();

    public TreeUnmarshaller(Object object, HierarchicalStreamReader hierarchicalStreamReader, ConverterLookup converterLookup, Mapper mapper) {
        this.root = object;
        this.reader = hierarchicalStreamReader;
        this.converterLookup = converterLookup;
        this.mapper = mapper;
    }

    public Object convertAnother(Object object, Class clazz) {
        return this.convertAnother(object, clazz, null);
    }

    public Object convertAnother(Object object, Class clazz, Converter converter) {
        clazz = this.mapper.defaultImplementationOf(clazz);
        if (converter == null) {
            converter = this.converterLookup.lookupConverterForType(clazz);
        } else if (!converter.canConvert(clazz)) {
            ConversionException conversionException = new ConversionException("Explicit selected converter cannot handle type");
            conversionException.add("item-type", clazz.getName());
            conversionException.add("converter-type", converter.getClass().getName());
            throw conversionException;
        }
        return this.convert(object, clazz, converter);
    }

    protected Object convert(Object object, Class clazz, Converter converter) {
        try {
            this.types.push(clazz);
            Object object2 = converter.unmarshal(this.reader, this);
            this.types.popSilently();
            return object2;
        }
        catch (ConversionException conversionException) {
            this.addInformationTo(conversionException, clazz, converter, object);
            throw conversionException;
        }
        catch (RuntimeException runtimeException) {
            ConversionException conversionException = new ConversionException(runtimeException);
            this.addInformationTo(conversionException, clazz, converter, object);
            throw conversionException;
        }
    }

    private void addInformationTo(ErrorWriter errorWriter, Class clazz, Converter converter, Object object) {
        errorWriter.add("class", clazz.getName());
        errorWriter.add("required-type", this.getRequiredType().getName());
        errorWriter.add("converter-type", converter.getClass().getName());
        if (converter instanceof ErrorReporter) {
            ((ErrorReporter)((Object)converter)).appendErrors(errorWriter);
        }
        if (object instanceof ErrorReporter) {
            ((ErrorReporter)object).appendErrors(errorWriter);
        }
        this.reader.appendErrors(errorWriter);
    }

    public void addCompletionCallback(Runnable runnable, int n2) {
        this.validationList.add(runnable, n2);
    }

    public Object currentObject() {
        return this.types.size() == 1 ? this.root : null;
    }

    public Class getRequiredType() {
        return (Class)this.types.peek();
    }

    public Object get(Object object) {
        this.lazilyCreateDataHolder();
        return this.dataHolder.get(object);
    }

    public void put(Object object, Object object2) {
        this.lazilyCreateDataHolder();
        this.dataHolder.put(object, object2);
    }

    public Iterator keys() {
        this.lazilyCreateDataHolder();
        return this.dataHolder.keys();
    }

    private void lazilyCreateDataHolder() {
        if (this.dataHolder == null) {
            this.dataHolder = new MapBackedDataHolder();
        }
    }

    public Object start(DataHolder dataHolder) {
        this.dataHolder = dataHolder;
        Class clazz = HierarchicalStreams.readClassType(this.reader, this.mapper);
        Object object = this.convertAnother(null, clazz);
        Iterator iterator = this.validationList.iterator();
        while (iterator.hasNext()) {
            Runnable runnable = (Runnable)iterator.next();
            runnable.run();
        }
        return object;
    }

    protected Mapper getMapper() {
        return this.mapper;
    }
}

