/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Base64Encoder {
    private static final char[] SIXTY_FOUR_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] REVERSE_MAPPING = new int[123];

    public String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; i2 += 3) {
            int n3 = Math.min(3, byArray.length - i2);
            int n4 = (byArray[i2] & 0xFF) << 16 | (n3 <= 1 ? 0 : byArray[i2 + 1] & 0xFF) << 8 | (n3 <= 2 ? 0 : byArray[i2 + 2] & 0xFF);
            for (int i3 = 0; i3 < 4; ++i3) {
                stringBuffer.append(n3 + 1 > i3 ? SIXTY_FOUR_CHARS[0x3F & n4 >> 6 * (3 - i3)] : (char)'=');
            }
            if ((n2 += 4) % 76 != 0) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public byte[] decode(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StringReader stringReader = new StringReader(string);
            for (int i2 = 0; i2 < string.length(); i2 += 4) {
                int[] nArray = new int[]{this.mapCharToInt(stringReader), this.mapCharToInt(stringReader), this.mapCharToInt(stringReader), this.mapCharToInt(stringReader)};
                int n2 = (nArray[0] & 0x3F) << 18 | (nArray[1] & 0x3F) << 12 | (nArray[2] & 0x3F) << 6 | nArray[3] & 0x3F;
                for (int i3 = 0; i3 < 3; ++i3) {
                    if (nArray[i3 + 1] < 0) continue;
                    byteArrayOutputStream.write(0xFF & n2 >> 8 * (2 - i3));
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new Error(iOException + ": " + iOException.getMessage());
        }
    }

    private int mapCharToInt(Reader reader) throws IOException {
        int n2;
        while ((n2 = reader.read()) != -1) {
            int n3 = REVERSE_MAPPING[n2];
            if (n3 != 0) {
                return n3 - 1;
            }
            if (n2 != 61) continue;
            return -1;
        }
        return -1;
    }

    static {
        for (int i2 = 0; i2 < SIXTY_FOUR_CHARS.length; ++i2) {
            Base64Encoder.REVERSE_MAPPING[Base64Encoder.SIXTY_FOUR_CHARS[i2]] = i2 + 1;
        }
    }
}

