/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;

public class Cloneables {
    public static Object clone(Object object) {
        if (object instanceof Cloneable) {
            if (object.getClass().isArray()) {
                Class<?> clazz = object.getClass().getComponentType();
                if (!clazz.isPrimitive()) {
                    return ((Object[])object).clone();
                }
                int n2 = Array.getLength(object);
                Object object2 = Array.newInstance(clazz, n2);
                while (n2-- > 0) {
                    Array.set(object2, n2, Array.get(object, n2));
                }
                return object2;
            }
            try {
                Method method = object.getClass().getMethod("clone", null);
                return method.invoke(object, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ObjectAccessException("Cloneable type has no clone method", noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ObjectAccessException("Cannot clone Cloneable type", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ObjectAccessException("Exception cloning Cloneable type", invocationTargetException.getCause());
            }
        }
        return null;
    }

    public static Object cloneIfPossible(Object object) {
        Object object2 = Cloneables.clone(object);
        return object2 == null ? object : object2;
    }
}

