/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import zz.com.thoughtworks.xstream.core.JVM;

public class CompositeClassLoader
extends ClassLoader {
    private final ReferenceQueue queue = new ReferenceQueue();
    private final List classLoaders = new ArrayList();

    public CompositeClassLoader() {
        this.addInternal(Object.class.getClassLoader());
        this.addInternal(this.getClass().getClassLoader());
    }

    public synchronized void add(ClassLoader classLoader) {
        this.cleanup();
        if (classLoader != null) {
            this.addInternal(classLoader);
        }
    }

    private void addInternal(ClassLoader classLoader) {
        WeakReference weakReference = null;
        Iterator iterator = this.classLoaders.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference2 = (WeakReference)iterator.next();
            ClassLoader classLoader2 = (ClassLoader)weakReference2.get();
            if (classLoader2 == null) {
                iterator.remove();
                continue;
            }
            if (classLoader2 != classLoader) continue;
            iterator.remove();
            weakReference = weakReference2;
        }
        this.classLoaders.add(0, weakReference != null ? weakReference : new WeakReference(classLoader, this.queue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String string) throws ClassNotFoundException {
        ArrayList arrayList = new ArrayList(this.classLoaders.size()){

            public boolean addAll(Collection collection) {
                boolean bl2 = false;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    bl2 |= this.add(iterator.next());
                }
                return bl2;
            }

            public boolean add(Object object) {
                Object t2 = ((WeakReference)object).get();
                if (t2 != null) {
                    return super.add(t2);
                }
                return false;
            }
        };
        ClassLoader classLoader = this;
        synchronized (classLoader) {
            this.cleanup();
            arrayList.addAll(this.classLoaders);
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        for (ClassLoader classLoader2 : arrayList) {
            if (classLoader2 == classLoader) {
                classLoader = null;
            }
            try {
                return classLoader2.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (classLoader != null) {
            return classLoader.loadClass(string);
        }
        throw new ClassNotFoundException(string);
    }

    private void cleanup() {
        WeakReference weakReference;
        while ((weakReference = (WeakReference)this.queue.poll()) != null) {
            this.classLoaders.remove(weakReference);
        }
    }

    static {
        if (JVM.is17()) {
            try {
                Method method = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", null);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

