/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.DataHolder;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.core.util.FastStack;
import zz.com.thoughtworks.xstream.io.StreamException;

public class CustomObjectInputStream
extends ObjectInputStream {
    private FastStack callbacks = new FastStack(1);
    private final ClassLoaderReference classLoaderReference;
    private static final String DATA_HOLDER_KEY = CustomObjectInputStream.class.getName();

    public static CustomObjectInputStream getInstance(DataHolder dataHolder, StreamCallback streamCallback) {
        return CustomObjectInputStream.getInstance(dataHolder, streamCallback, (ClassLoader)null);
    }

    public static synchronized CustomObjectInputStream getInstance(DataHolder dataHolder, StreamCallback streamCallback, ClassLoader classLoader) {
        return CustomObjectInputStream.getInstance(dataHolder, streamCallback, new ClassLoaderReference(classLoader));
    }

    public static synchronized CustomObjectInputStream getInstance(DataHolder dataHolder, StreamCallback streamCallback, ClassLoaderReference classLoaderReference) {
        try {
            CustomObjectInputStream customObjectInputStream = (CustomObjectInputStream)dataHolder.get(DATA_HOLDER_KEY);
            if (customObjectInputStream == null) {
                customObjectInputStream = new CustomObjectInputStream(streamCallback, classLoaderReference);
                dataHolder.put(DATA_HOLDER_KEY, customObjectInputStream);
            } else {
                customObjectInputStream.pushCallback(streamCallback);
            }
            return customObjectInputStream;
        }
        catch (SecurityException securityException) {
            throw new ObjectAccessException("Cannot create CustomObjectStream", securityException);
        }
        catch (IOException iOException) {
            throw new StreamException("Cannot create CustomObjectStream", iOException);
        }
    }

    public CustomObjectInputStream(StreamCallback streamCallback, ClassLoaderReference classLoaderReference) throws IOException, SecurityException {
        this.callbacks.push(streamCallback);
        this.classLoaderReference = classLoaderReference;
    }

    public CustomObjectInputStream(StreamCallback streamCallback, ClassLoader classLoader) throws IOException, SecurityException {
        this(streamCallback, new ClassLoaderReference(classLoader));
    }

    public void pushCallback(StreamCallback streamCallback) {
        this.callbacks.push(streamCallback);
    }

    public StreamCallback popCallback() {
        return (StreamCallback)this.callbacks.pop();
    }

    public StreamCallback peekCallback() {
        return (StreamCallback)this.callbacks.peek();
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = this.classLoaderReference.getReference();
        if (classLoader == null) {
            return super.resolveClass(objectStreamClass);
        }
        return Class.forName(objectStreamClass.getName(), false, classLoader);
    }

    public void defaultReadObject() throws IOException {
        this.peekCallback().defaultReadObject();
    }

    protected Object readObjectOverride() throws IOException {
        return this.peekCallback().readFromStream();
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    public boolean readBoolean() throws IOException {
        return (Boolean)this.peekCallback().readFromStream();
    }

    public byte readByte() throws IOException {
        return (Byte)this.peekCallback().readFromStream();
    }

    public int readUnsignedByte() throws IOException {
        int n2 = ((Byte)this.peekCallback().readFromStream()).byteValue();
        if (n2 < 0) {
            n2 += 127;
        }
        return n2;
    }

    public int readInt() throws IOException {
        return (Integer)this.peekCallback().readFromStream();
    }

    public char readChar() throws IOException {
        return ((Character)this.peekCallback().readFromStream()).charValue();
    }

    public float readFloat() throws IOException {
        return ((Float)this.peekCallback().readFromStream()).floatValue();
    }

    public double readDouble() throws IOException {
        return (Double)this.peekCallback().readFromStream();
    }

    public long readLong() throws IOException {
        return (Long)this.peekCallback().readFromStream();
    }

    public short readShort() throws IOException {
        return (Short)this.peekCallback().readFromStream();
    }

    public int readUnsignedShort() throws IOException {
        int n2 = ((Short)this.peekCallback().readFromStream()).shortValue();
        if (n2 < 0) {
            n2 += Short.MAX_VALUE;
        }
        return n2;
    }

    public String readUTF() throws IOException {
        return (String)this.peekCallback().readFromStream();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2 = (byte[])this.peekCallback().readFromStream();
        System.arraycopy(byArray2, 0, byArray, n2, n3);
    }

    public int read() throws IOException {
        return this.readUnsignedByte();
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2 = (byte[])this.peekCallback().readFromStream();
        if (byArray2.length != n3) {
            throw new StreamCorruptedException("Expected " + n3 + " bytes from stream, got " + byArray2.length);
        }
        System.arraycopy(byArray2, 0, byArray, n2, n3);
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public ObjectInputStream.GetField readFields() throws IOException {
        return new CustomGetField(this.peekCallback().readFieldsFromStream());
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int n2) throws NotActiveException, InvalidObjectException {
        this.peekCallback().registerValidation(objectInputValidation, n2);
    }

    public void close() throws IOException {
        this.peekCallback().close();
    }

    public int available() {
        throw new UnsupportedOperationException();
    }

    public String readLine() {
        throw new UnsupportedOperationException();
    }

    public int skipBytes(int n2) {
        throw new UnsupportedOperationException();
    }

    public long skip(long l2) {
        throw new UnsupportedOperationException();
    }

    public void mark(int n2) {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public boolean markSupported() {
        return false;
    }

    private class CustomGetField
    extends ObjectInputStream.GetField {
        private Map fields;

        public CustomGetField(Map map) {
            this.fields = map;
        }

        public ObjectStreamClass getObjectStreamClass() {
            throw new UnsupportedOperationException();
        }

        private Object get(String string) {
            return this.fields.get(string);
        }

        public boolean defaulted(String string) {
            return !this.fields.containsKey(string);
        }

        public byte get(String string, byte by2) {
            return this.defaulted(string) ? by2 : (Byte)this.get(string);
        }

        public char get(String string, char c2) {
            return this.defaulted(string) ? c2 : ((Character)this.get(string)).charValue();
        }

        public double get(String string, double d2) {
            return this.defaulted(string) ? d2 : (Double)this.get(string);
        }

        public float get(String string, float f2) {
            return this.defaulted(string) ? f2 : ((Float)this.get(string)).floatValue();
        }

        public int get(String string, int n2) {
            return this.defaulted(string) ? n2 : (Integer)this.get(string);
        }

        public long get(String string, long l2) {
            return this.defaulted(string) ? l2 : (Long)this.get(string);
        }

        public short get(String string, short s2) {
            return this.defaulted(string) ? s2 : (Short)this.get(string);
        }

        public boolean get(String string, boolean bl2) {
            return this.defaulted(string) ? bl2 : (Boolean)this.get(string);
        }

        public Object get(String string, Object object) {
            return this.defaulted(string) ? object : this.get(string);
        }
    }

    public static interface StreamCallback {
        public Object readFromStream() throws IOException;

        public Map readFieldsFromStream() throws IOException;

        public void defaultReadObject() throws IOException;

        public void registerValidation(ObjectInputValidation var1, int var2) throws NotActiveException, InvalidObjectException;

        public void close() throws IOException;
    }
}

