/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.DataHolder;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.util.FastStack;
import zz.com.thoughtworks.xstream.core.util.OrderRetainingMap;
import zz.com.thoughtworks.xstream.io.StreamException;

public class CustomObjectOutputStream
extends ObjectOutputStream {
    private FastStack callbacks = new FastStack(1);
    private FastStack customFields = new FastStack(1);
    private static final String DATA_HOLDER_KEY = CustomObjectOutputStream.class.getName();

    public static synchronized CustomObjectOutputStream getInstance(DataHolder dataHolder, StreamCallback streamCallback) {
        try {
            CustomObjectOutputStream customObjectOutputStream = (CustomObjectOutputStream)dataHolder.get(DATA_HOLDER_KEY);
            if (customObjectOutputStream == null) {
                customObjectOutputStream = new CustomObjectOutputStream(streamCallback);
                dataHolder.put(DATA_HOLDER_KEY, customObjectOutputStream);
            } else {
                customObjectOutputStream.pushCallback(streamCallback);
            }
            return customObjectOutputStream;
        }
        catch (SecurityException securityException) {
            throw new ObjectAccessException("Cannot create CustomObjectStream", securityException);
        }
        catch (IOException iOException) {
            throw new StreamException("Cannot create CustomObjectStream", iOException);
        }
    }

    public CustomObjectOutputStream(StreamCallback streamCallback) throws IOException, SecurityException {
        this.callbacks.push(streamCallback);
    }

    public void pushCallback(StreamCallback streamCallback) {
        this.callbacks.push(streamCallback);
    }

    public StreamCallback popCallback() {
        return (StreamCallback)this.callbacks.pop();
    }

    public StreamCallback peekCallback() {
        return (StreamCallback)this.callbacks.peek();
    }

    public void defaultWriteObject() throws IOException {
        this.peekCallback().defaultWriteObject();
    }

    protected void writeObjectOverride(Object object) throws IOException {
        this.peekCallback().writeToStream(object);
    }

    public void writeBoolean(boolean bl2) throws IOException {
        this.peekCallback().writeToStream(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void writeByte(int n2) throws IOException {
        this.peekCallback().writeToStream(new Byte((byte)n2));
    }

    public void writeInt(int n2) throws IOException {
        this.peekCallback().writeToStream(new Integer(n2));
    }

    public void writeChar(int n2) throws IOException {
        this.peekCallback().writeToStream(new Character((char)n2));
    }

    public void writeDouble(double d2) throws IOException {
        this.peekCallback().writeToStream(new Double(d2));
    }

    public void writeFloat(float f2) throws IOException {
        this.peekCallback().writeToStream(new Float(f2));
    }

    public void writeLong(long l2) throws IOException {
        this.peekCallback().writeToStream(new Long(l2));
    }

    public void writeShort(int n2) throws IOException {
        this.peekCallback().writeToStream(new Short((short)n2));
    }

    public void write(byte[] byArray) throws IOException {
        this.peekCallback().writeToStream(byArray);
    }

    public void writeChars(String string) throws IOException {
        this.peekCallback().writeToStream(string.toCharArray());
    }

    public void writeUTF(String string) throws IOException {
        this.peekCallback().writeToStream(string);
    }

    public void write(int n2) throws IOException {
        this.peekCallback().writeToStream(new Byte((byte)n2));
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        this.peekCallback().writeToStream(byArray2);
    }

    public void flush() throws IOException {
        this.peekCallback().flush();
    }

    public void close() throws IOException {
        this.peekCallback().close();
    }

    public ObjectOutputStream.PutField putFields() {
        CustomPutField customPutField = new CustomPutField();
        this.customFields.push(customPutField);
        return customPutField;
    }

    public void writeFields() throws IOException {
        CustomPutField customPutField = (CustomPutField)this.customFields.pop();
        this.peekCallback().writeFieldsToStream(customPutField.asMap());
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void useProtocolVersion(int n2) {
        throw new UnsupportedOperationException();
    }

    public void writeBytes(String string) {
        throw new UnsupportedOperationException();
    }

    public void writeUnshared(Object object) {
        throw new UnsupportedOperationException();
    }

    private class CustomPutField
    extends ObjectOutputStream.PutField {
        private final Map fields = new OrderRetainingMap();

        private CustomPutField() {
        }

        public Map asMap() {
            return this.fields;
        }

        public void write(ObjectOutput objectOutput) throws IOException {
            CustomObjectOutputStream.this.peekCallback().writeToStream(this.asMap());
        }

        public void put(String string, Object object) {
            this.fields.put(string, object);
        }

        public void put(String string, byte by2) {
            this.put(string, new Byte(by2));
        }

        public void put(String string, char c2) {
            this.put(string, new Character(c2));
        }

        public void put(String string, double d2) {
            this.put(string, new Double(d2));
        }

        public void put(String string, float f2) {
            this.put(string, new Float(f2));
        }

        public void put(String string, int n2) {
            this.put(string, new Integer(n2));
        }

        public void put(String string, long l2) {
            this.put(string, new Long(l2));
        }

        public void put(String string, short s2) {
            this.put(string, new Short(s2));
        }

        public void put(String string, boolean bl2) {
            this.put(string, bl2 ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public static interface StreamCallback {
        public void writeToStream(Object var1) throws IOException;

        public void writeFieldsToStream(Map var1) throws IOException;

        public void defaultWriteObject() throws IOException;

        public void flush() throws IOException;

        public void close() throws IOException;
    }
}

